/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.discovery.gce;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.ClassInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cloud.gce.GceInstancesService;
import org.opensearch.cloud.gce.GceInstancesServiceImpl;
import org.opensearch.cloud.gce.GceMetadataService;
import org.opensearch.cloud.gce.network.GceNameResolver;
import org.opensearch.common.Booleans;
import org.opensearch.common.SetOnce;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.discovery.SeedHostsProvider;
import org.opensearch.discovery.gce.GceSeedHostsProvider;
import org.opensearch.plugins.DiscoveryPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.secure_sm.AccessController;
import org.opensearch.transport.TransportService;

public class GceDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
Closeable {
    private static final boolean ALLOW_REROUTE_GCE_SETTINGS = Booleans.parseBoolean((String)System.getProperty("opensearch.allow_reroute_gce_settings", "false"));
    public static final String GCE = "gce";
    protected final Settings settings;
    private static final Logger logger = LogManager.getLogger(GceDiscoveryPlugin.class);
    private final SetOnce<GceInstancesService> gceInstancesService = new SetOnce();

    public GceDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        logger.trace("starting gce discovery plugin...");
    }

    protected GceInstancesService createGceInstancesService() {
        return new GceInstancesServiceImpl(this.settings);
    }

    public Map<String, Supplier<SeedHostsProvider>> getSeedHostProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(GCE, () -> {
            this.gceInstancesService.set((Object)this.createGceInstancesService());
            return new GceSeedHostsProvider(this.settings, (GceInstancesService)this.gceInstancesService.get(), transportService, networkService);
        });
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        logger.debug("Register _gce_, _gce:xxx network names");
        return new GceNameResolver(new GceMetadataService(settings));
    }

    public List<Setting<?>> getSettings() {
        ArrayList<Setting> settings = new ArrayList<Setting>(Arrays.asList(GceInstancesService.PROJECT_SETTING, GceInstancesService.ZONE_SETTING, GceSeedHostsProvider.TAGS_SETTING, GceInstancesService.REFRESH_SETTING, GceInstancesService.RETRY_SETTING, GceInstancesService.MAX_WAIT_SETTING));
        if (ALLOW_REROUTE_GCE_SETTINGS) {
            settings.add(GceMetadataService.GCE_HOST);
            settings.add(GceInstancesServiceImpl.GCE_ROOT_URL);
        }
        return Collections.unmodifiableList(settings);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.gceInstancesService.get()));
    }

    static {
        AccessController.doPrivileged(() -> ClassInfo.of(HttpHeaders.class, (boolean)true));
    }
}

