﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector/Inspector_EXPORTS.h>
#include <aws/inspector/model/NoSuchEntityErrorCode.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Inspector {
namespace Model {

/**
 * <p>The request was rejected because it referenced an entity that does not exist.
 * The error code describes the entity.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/NoSuchEntityException">AWS
 * API Reference</a></p>
 */
class NoSuchEntityException {
 public:
  AWS_INSPECTOR_API NoSuchEntityException() = default;
  AWS_INSPECTOR_API NoSuchEntityException(Aws::Utils::Json::JsonView jsonValue);
  AWS_INSPECTOR_API NoSuchEntityException& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_INSPECTOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Details of the exception error.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  NoSuchEntityException& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Code that indicates the type of error that is generated.</p>
   */
  inline NoSuchEntityErrorCode GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  inline void SetErrorCode(NoSuchEntityErrorCode value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = value;
  }
  inline NoSuchEntityException& WithErrorCode(NoSuchEntityErrorCode value) {
    SetErrorCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>You can immediately retry your request.</p>
   */
  inline bool GetCanRetry() const { return m_canRetry; }
  inline bool CanRetryHasBeenSet() const { return m_canRetryHasBeenSet; }
  inline void SetCanRetry(bool value) {
    m_canRetryHasBeenSet = true;
    m_canRetry = value;
  }
  inline NoSuchEntityException& WithCanRetry(bool value) {
    SetCanRetry(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_message;

  NoSuchEntityErrorCode m_errorCode{NoSuchEntityErrorCode::NOT_SET};

  bool m_canRetry{false};
  bool m_messageHasBeenSet = false;
  bool m_errorCodeHasBeenSet = false;
  bool m_canRetryHasBeenSet = false;
};

}  // namespace Model
}  // namespace Inspector
}  // namespace Aws
