﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/schemas/SchemasRequest.h>
#include <aws/schemas/Schemas_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Schemas {
namespace Model {

/**
 */
class DeleteSchemaRequest : public SchemasRequest {
 public:
  AWS_SCHEMAS_API DeleteSchemaRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteSchema"; }

  AWS_SCHEMAS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the registry.</p>
   */
  inline const Aws::String& GetRegistryName() const { return m_registryName; }
  inline bool RegistryNameHasBeenSet() const { return m_registryNameHasBeenSet; }
  template <typename RegistryNameT = Aws::String>
  void SetRegistryName(RegistryNameT&& value) {
    m_registryNameHasBeenSet = true;
    m_registryName = std::forward<RegistryNameT>(value);
  }
  template <typename RegistryNameT = Aws::String>
  DeleteSchemaRequest& WithRegistryName(RegistryNameT&& value) {
    SetRegistryName(std::forward<RegistryNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schema.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  inline bool SchemaNameHasBeenSet() const { return m_schemaNameHasBeenSet; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  DeleteSchemaRequest& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registryName;

  Aws::String m_schemaName;
  bool m_registryNameHasBeenSet = false;
  bool m_schemaNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
