/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.hana.model.HANADataSource;
import org.jkiss.dbeaver.ext.hana.model.HANASchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class HANASchemaManager
extends SQLObjectEditor<HANASchema, HANADataSource>
implements DBEObjectRenamer<HANASchema> {
    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    public boolean canDeleteObject(@NotNull HANASchema object) {
        return true;
    }

    protected String getBaseObjectName() {
        return "NEW_SCHEMA";
    }

    protected HANASchema createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        if (container instanceof HANADataSource) {
            HANADataSource dataSource = (HANADataSource)((Object)container);
            HANASchema schema = new HANASchema(dataSource, null, "NEW_SCHEMA");
            this.setNewObjectName(monitor, (DBSObject)dataSource, (DBSObject)schema);
            return schema;
        }
        return null;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", "CREATE SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)command.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL)));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull HANASchema object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        HANASchema schema = (HANASchema)command.getObject();
        GenericDataSource dataSource = schema.getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename schema", "RENAME SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)command.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RESTRICT"));
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, HANASchema> getObjectsCache(HANASchema object) {
        return object.getDataSource().getSchemaCache();
    }
}

