/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model;

import java.sql.Connection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuckDBExecutionContext
extends GenericExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(DuckDBExecutionContext.class);
    private String activeCatalogName;

    public DuckDBExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public GenericCatalog getDefaultCatalog() {
        return this.activeCatalogName == null ? null : this.getDataSource().getCatalog(this.activeCatalogName);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        Object bootstrap;
        String bootstrapCatalogName;
        boolean changed = super.refreshDefaults(monitor, useBootstrapSettings);
        if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrapCatalogName = (bootstrap = this.getBootstrapSettings()).getDefaultCatalogName())) && !bootstrapCatalogName.equals(this.activeCatalogName)) {
            this.activeCatalogName = bootstrapCatalogName;
            changed = true;
        }
        if (this.supportsCatalogChange() && CommonUtils.isEmpty((String)this.activeCatalogName)) {
            try {
                bootstrap = null;
                Object var5_7 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active catalog");){
                    String currentCatalog = JDBCUtils.queryString((Connection)session, (String)"SELECT current_catalog()", (Object[])new Object[0]);
                    if (!CommonUtils.isEmpty((String)currentCatalog) && !currentCatalog.equals(this.activeCatalogName)) {
                        this.activeCatalogName = currentCatalog;
                        changed = true;
                    }
                }
                catch (Throwable throwable) {
                    if (bootstrap == null) {
                        bootstrap = throwable;
                    } else if (bootstrap != throwable) {
                        ((Throwable)bootstrap).addSuppressed(throwable);
                    }
                    throw bootstrap;
                }
            }
            catch (Exception e) {
                log.warn("Error while setting active catalog", (Throwable)e);
            }
        }
        return changed;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, GenericCatalog catalog, GenericSchema schema) throws DBCException {
        if (catalog == null) {
            return;
        }
        String newCatalogName = catalog.getName();
        if (CommonUtils.equalObjects((Object)this.activeCatalogName, (Object)newCatalogName)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                JDBCUtils.executeSQL((Connection)session, (String)("USE " + newCatalogName), (Object[])new Object[0]);
                this.activeCatalogName = newCatalogName;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            try {
                throw new DBException("Failed to set active catalog to " + newCatalogName, (Throwable)e);
            }
            catch (DBException ex) {
                log.warn("Error setting active catalog", (Throwable)ex);
            }
        }
        super.setDefaultCatalog(monitor, catalog, schema);
    }

    public void initDefaultsFrom(DBRProgressMonitor monitor, GenericExecutionContext context) {
        try {
            super.initDefaultsFrom(monitor, context);
        }
        catch (DBCException e) {
            log.warn("Error initializing defaults from context", (Throwable)e);
        }
        if (context instanceof DuckDBExecutionContext) {
            DuckDBExecutionContext duckDBContext = (DuckDBExecutionContext)context;
            this.activeCatalogName = duckDBContext.activeCatalogName;
        }
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.activeCatalogName, this.getDefaultSchemaCached());
    }
}

