/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.map.CodeAttribute;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.CodeAttributeMatcher;

public class ClassNode
extends CodeNode {
    private final JavaClass javaClass;
    private Set<JavaClass> innerClasses;
    static final String ANNOTATION_ICON_NAME = "code_annotation";
    static final String INTERFACE_ICON_NAME = "code_interface";
    static final String ABSTRACT_CLASS_ICON_NAME = "code_abstractClass";
    static final String CLASS_ICON_NAME = "code_class";
    static final String ENUM_ICON_NAME = "code_enum";

    ClassNode(JavaClass javaClass, CodeMap map, int groupIndex) {
        super(map, groupIndex);
        this.javaClass = javaClass;
        this.innerClasses = null;
        this.setFolded(false);
        this.setIdWithIndex(javaClass.getName());
        String nodeText = ClassNode.classNameWithNestedClasses(javaClass);
        this.setText(nodeText);
    }

    @Override
    void updateCodeAttributes(CodeAttributeMatcher codeAttributeMatcher) {
        super.updateCodeAttributes(codeAttributeMatcher);
        this.getMap().matchingCriteria(this.javaClass).ifPresent(criteria -> {
            NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel((NodeModel)this);
            attributes.addRowNoUndo((NodeModel)this, (Attribute)new CodeAttribute("Speciality", criteria.name()));
        });
    }

    @Override
    Set<? extends JavaAnnotation<? extends HasName>> getAnnotations() {
        return this.javaClass.getAnnotations();
    }

    @Override
    Set<JavaType> getInterfaces() {
        return this.javaClass.getInterfaces();
    }

    @Override
    protected Stream<JavaClass> getClasses() {
        return Stream.of(this.javaClass);
    }

    public static String classNameWithNestedClasses(JavaClass javaClass) {
        String simpleName = ClassNode.getSimpleName(javaClass);
        if (javaClass.isMemberClass()) {
            return javaClass.getEnclosingClass().map(ec -> ClassNode.classNameWithNestedClasses(ec) + "." + simpleName).orElse(simpleName);
        }
        return simpleName;
    }

    public static String getSimpleName(JavaClass javaClass) {
        String simpleName = javaClass.getSimpleName();
        if (simpleName.isEmpty()) {
            String fullName = javaClass.getName();
            if (javaClass.isAnonymousClass() && javaClass.getEnclosingClass().isPresent()) {
                JavaClass enclosingNamedClass = ClassNode.findEnclosingNamedClass((JavaClass)javaClass.getEnclosingClass().get());
                return ClassNode.getSimpleName(enclosingNamedClass) + fullName.substring(enclosingNamedClass.getName().length());
            }
            if (javaClass.isArray()) {
                return ClassNode.getSimpleName(javaClass.getBaseComponentType()) + "[]";
            }
            if (javaClass.isMemberClass() && javaClass.getEnclosingClass().isPresent()) {
                JavaClass enclosingNamedClass = (JavaClass)javaClass.getEnclosingClass().get();
                return fullName.substring(enclosingNamedClass.getName().length() + 1);
            }
            String packageName = javaClass.getPackage().getName();
            return packageName.isEmpty() ? fullName : fullName.substring(packageName.length() + 1);
        }
        return simpleName;
    }

    @Override
    HasName getCodeElement() {
        return this.javaClass;
    }

    public int getChildCount() {
        return 0;
    }

    protected List<NodeModel> getChildrenInternal() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getText();
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return this.getDependencies(JavaClass::getDirectDependenciesFromSelf).filter(dep -> ClassNode.hasValidTopLevelClass(dep.getTargetClass()));
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return this.getDependencies(JavaClass::getDirectDependenciesToSelf).filter(dep -> ClassNode.hasValidTopLevelClass(dep.getOriginClass()));
    }

    private Stream<Dependency> getDependencies(Function<? super JavaClass, ? extends Set<Dependency>> mapper) {
        return this.innerClasses == null ? mapper.apply((JavaClass)this.javaClass).stream() : Stream.concat(Stream.of(this.javaClass), this.innerClasses.stream()).map(mapper).flatMap(Collection::stream).filter(this::connectsDifferentNodes);
    }

    private boolean connectsDifferentNodes(Dependency dep) {
        return ClassNode.findEnclosingNamedClass(dep.getOriginClass()) != ClassNode.findEnclosingNamedClass(dep.getTargetClass());
    }

    void registerInnerClass(JavaClass innerClass) {
        if (innerClass == this.javaClass) {
            return;
        }
        if (this.innerClasses == null) {
            this.innerClasses = new HashSet<JavaClass>();
        }
        this.innerClasses.add(innerClass);
    }

    @Override
    String getUIIconName() {
        if (this.javaClass.isAnnotation()) {
            return ANNOTATION_ICON_NAME;
        }
        if (this.javaClass.isInterface()) {
            return INTERFACE_ICON_NAME;
        }
        if (this.javaClass.isEnum()) {
            return ENUM_ICON_NAME;
        }
        if (this.javaClass.getModifiers().contains(JavaModifier.ABSTRACT)) {
            return ABSTRACT_CLASS_ICON_NAME;
        }
        return CLASS_ICON_NAME;
    }

    @Override
    long getClassCount() {
        return 1L;
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(INTERFACE_ICON_NAME, "code/interface.svg");
        IconStoreFactory.INSTANCE.createStateIcon(ABSTRACT_CLASS_ICON_NAME, "code/classAbstract.svg");
        IconStoreFactory.INSTANCE.createStateIcon(CLASS_ICON_NAME, "code/class.svg");
        IconStoreFactory.INSTANCE.createStateIcon(ENUM_ICON_NAME, "code/enum.svg");
        IconStoreFactory.INSTANCE.createStateIcon(ANNOTATION_ICON_NAME, "code/annotation.svg");
    }
}

