/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

class JavaClassTransitiveDependencies {
    private JavaClassTransitiveDependencies() {
    }

    static Set<Dependency> findTransitiveDependenciesFrom(JavaClass javaClass) {
        ImmutableSet.Builder<Dependency> transitiveDependencies = ImmutableSet.builder();
        HashSet<JavaClass> analyzedClasses = new HashSet<JavaClass>();
        JavaClassTransitiveDependencies.addTransitiveDependenciesFrom(javaClass, transitiveDependencies, analyzedClasses);
        return transitiveDependencies.build();
    }

    private static void addTransitiveDependenciesFrom(JavaClass javaClass, ImmutableSet.Builder<Dependency> transitiveDependencies, Set<JavaClass> analyzedClasses) {
        analyzedClasses.add(javaClass);
        HashSet<JavaClass> targetClassesToRecurse = new HashSet<JavaClass>();
        for (Dependency dependency : javaClass.getDirectDependenciesFromSelf()) {
            transitiveDependencies.add((Object)dependency);
            targetClassesToRecurse.add(dependency.getTargetClass().getBaseComponentType());
        }
        for (JavaClass targetClass : targetClassesToRecurse) {
            if (analyzedClasses.contains(targetClass)) continue;
            JavaClassTransitiveDependencies.addTransitiveDependenciesFrom(targetClass, transitiveDependencies, analyzedClasses);
        }
    }
}

