/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface UrlSource
extends Iterable<URL> {

    @Internal
    public static class From {
        private static final Logger LOG = LoggerFactory.getLogger(From.class);
        private static final String CLASS_PATH_PROPERTY_NAME = "java.class.path";
        private static final String BOOT_CLASS_PATH_PROPERTY_NAME = "sun.boot.class.path";
        private static final Function<URI, URL> URI_TO_URL = input -> {
            try {
                return input.toURL();
            }
            catch (MalformedURLException e) {
                throw new ArchUnitException.LocationException(e);
            }
        };

        static UrlSource iterable(Iterable<URL> urls) {
            final Iterable<URL> uniqueUrls = From.unique(urls);
            return new UrlSource(){

                @Override
                public Iterator<URL> iterator() {
                    return uniqueUrls.iterator();
                }

                public String toString() {
                    return String.valueOf(uniqueUrls);
                }
            };
        }

        private static Iterable<URL> unique(Iterable<URL> urls) {
            return StreamSupport.stream(urls.spliterator(), false).map(Location::toURI).distinct().map(URI_TO_URL).collect(Collectors.toList());
        }

        static UrlSource classPathSystemProperties() {
            ImmutableCollection directlySpecifiedAsProperties = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(From.findUrlsForClassPathProperty(BOOT_CLASS_PATH_PROPERTY_NAME))).addAll(From.findUrlsForClassPathProperty(CLASS_PATH_PROPERTY_NAME))).build();
            Iterable<URL> transitivelySpecifiedThroughManifest = From.readClasspathEntriesFromManifests((List<URL>)((Object)directlySpecifiedAsProperties));
            return From.iterable(Iterables.concat(directlySpecifiedAsProperties, transitivelySpecifiedThroughManifest));
        }

        private static Iterable<URL> readClasspathEntriesFromManifests(List<URL> urls) {
            HashSet<URI> result = new HashSet<URI>();
            From.readClasspathUriEntriesFromManifests(result, urls.stream().map(Location::toURI).collect(Collectors.toSet()));
            return result.stream().map(URI_TO_URL).collect(Collectors.toList());
        }

        private static void readClasspathUriEntriesFromManifests(Set<URI> result, Set<URI> uris) {
            uris.stream().filter(url -> url.getScheme().equals("jar")).map(From::readClasspathEntriesFromManifest).map(manifestUris -> ImmutableSet.copyOf(Sets.difference(manifestUris, result))).forEach(unknownSoFar -> {
                result.addAll((Collection<URI>)unknownSoFar);
                From.readClasspathUriEntriesFromManifests(result, unknownSoFar);
            });
        }

        private static Set<URI> readClasspathEntriesFromManifest(URI url) {
            Optional<Path> jarPath = From.findParentPathOf(url);
            if (!jarPath.isPresent()) {
                return Collections.emptySet();
            }
            HashSet<URI> result = new HashSet<URI>();
            for (String classpathEntry : Splitter.on(" ").omitEmptyStrings().split(From.readManifestClasspath(url))) {
                From.parseManifestClasspathEntry(jarPath.get(), classpathEntry).ifPresent(result::add);
            }
            return result;
        }

        private static Optional<Path> findParentPathOf(URI uri) {
            try {
                return Optional.ofNullable(Paths.get(From.ensureFileUrl(uri).toURI()).getParent());
            }
            catch (Exception e) {
                LOG.warn("Could not find parent folder for " + uri, (Throwable)e);
                return Optional.empty();
            }
        }

        private static URL ensureFileUrl(URI url) throws IOException {
            return ((JarURLConnection)url.toURL().openConnection()).getJarFileURL();
        }

        private static String readManifestClasspath(URI uri) {
            try {
                String result = (String)((JarURLConnection)uri.toURL().openConnection()).getMainAttributes().get(Attributes.Name.CLASS_PATH);
                return Strings.nullToEmpty(result);
            }
            catch (Exception e) {
                return "";
            }
        }

        private static Optional<URI> parseManifestClasspathEntry(Path parent, String classpathEntry) {
            if (From.isUrl(classpathEntry)) {
                return From.parseUrl(parent, classpathEntry);
            }
            return From.parsePath(parent, classpathEntry);
        }

        private static boolean isUrl(String classpathEntry) {
            return classpathEntry.startsWith("file:") || classpathEntry.startsWith("jar:");
        }

        private static Optional<URI> parseUrl(Path parent, String classpathUrlEntry) {
            try {
                return Optional.of(From.convertToJarUrlIfNecessary(parent.toUri().resolve(URI.create(classpathUrlEntry).getRawSchemeSpecificPart())));
            }
            catch (Exception e) {
                LOG.warn("Cannot parse URL classpath entry " + classpathUrlEntry, (Throwable)e);
                return Optional.empty();
            }
        }

        private static Optional<URI> parsePath(Path parent, String classpathFilePathEntry) {
            try {
                Path path = Paths.get(classpathFilePathEntry, new String[0]);
                if (!path.isAbsolute()) {
                    path = parent.resolve(path);
                }
                return Optional.of(From.convertToJarUrlIfNecessary(path.toUri()));
            }
            catch (Exception e) {
                LOG.warn("Cannot parse file path classpath entry " + classpathFilePathEntry, (Throwable)e);
                return Optional.empty();
            }
        }

        private static URI convertToJarUrlIfNecessary(URI uri) {
            if (uri.toString().endsWith(".jar")) {
                return URI.create("jar:" + uri + "!/");
            }
            return uri;
        }

        private static List<URL> findUrlsForClassPathProperty(String propertyName) {
            String classPathProperty = System.getProperty(propertyName, "");
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : Splitter.on(File.pathSeparator).omitEmptyStrings().split(classPathProperty)) {
                From.parseClassPathEntry(path).ifPresent(urls::add);
            }
            LOG.debug("Found URLs on {}: {}", (Object)propertyName, urls);
            return urls;
        }

        private static Optional<URL> parseClassPathEntry(String path) {
            return path.endsWith(".jar") ? From.newJarUrl(path) : From.newFileUri(path);
        }

        private static Optional<URL> newFileUri(String path) {
            path = path.endsWith(File.separator) || path.endsWith(".class") ? path : path + File.separator;
            try {
                return Optional.of(Paths.get(path, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException e) {
                LOG.warn("Cannot parse URL from path " + path, (Throwable)e);
                return Optional.empty();
            }
            catch (InvalidPathException e) {
                Optional<URL> fallback = From.tryResolvePathFromUrl(path);
                if (!fallback.isPresent()) {
                    LOG.warn("Cannot parse URL from path " + path, (Throwable)e);
                }
                return fallback;
            }
        }

        private static Optional<URL> tryResolvePathFromUrl(String path) {
            try {
                return Optional.of(Paths.get(new URL("file:" + path).toURI()).toUri().toURL());
            }
            catch (MalformedURLException | URISyntaxException | InvalidPathException e) {
                return Optional.empty();
            }
        }

        private static Optional<URL> newJarUrl(String path) {
            Optional<URL> fileUri = From.newFileUri(path);
            try {
                return fileUri.isPresent() ? Optional.of(new URL("jar:" + fileUri.get() + "!/")) : Optional.empty();
            }
            catch (MalformedURLException e) {
                LOG.warn("Cannot parse URL from path " + path, (Throwable)e);
                return Optional.empty();
            }
        }
    }
}

