/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.util.Msg;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.help.UnsupportedOperationException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsImpl
implements Settings,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> map;
    private Settings defaultSettings;
    private ChangeListener listener;
    private Object changeSourceObj;
    private boolean immutable;
    private Predicate<String> allowedSettingPredicate;
    public static final Settings NO_SETTINGS = new SettingsImpl(true){

        @Override
        public void setDefaultSettings(Settings settings) {
            throw new UnsupportedOperationException();
        }
    };

    public SettingsImpl() {
        this.map = new HashMap<String, Object>();
    }

    public SettingsImpl(Predicate<String> allowedSettingPredicate) {
        this.map = new HashMap<String, Object>();
        this.allowedSettingPredicate = allowedSettingPredicate;
    }

    public SettingsImpl(Settings settings) {
        this();
        if (settings != null) {
            String[] names;
            for (String name : names = settings.getNames()) {
                this.map.put(name, settings.getValue(name));
            }
            this.defaultSettings = settings.getDefaultSettings();
        }
    }

    public SettingsImpl(boolean immutable) {
        this.immutable = immutable;
        this.map = new HashMap<String, Object>();
    }

    public SettingsImpl(ChangeListener listener, Object changeSourceObj) {
        this();
        this.listener = listener;
        this.changeSourceObj = changeSourceObj;
    }

    @Override
    public boolean isImmutableSettings() {
        return this.immutable;
    }

    @Override
    public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
        if (this.immutable) {
            return false;
        }
        return this.allowedSettingPredicate == null || this.allowedSettingPredicate.test(settingsDefinition.getStorageKey());
    }

    private boolean checkSetting(String type, String name) {
        if (!this.checkImmutableSetting(type, name)) {
            return false;
        }
        if (name != null && this.allowedSettingPredicate != null && !this.allowedSettingPredicate.test(name)) {
            Msg.warn((Object)this, (Object)("Ignored disallowed setting '" + name + "'"));
            return false;
        }
        return true;
    }

    private boolean checkImmutableSetting(String type, String name) {
        if (this.immutable) {
            Object typeStr = "";
            if (type != null) {
                typeStr = type + " ";
            }
            Object nameStr = ": " + name;
            if (name == null) {
                nameStr = "s";
            }
            Msg.warn(SettingsImpl.class, (Object)("Ignored invalid attempt to modify immutable " + (String)typeStr + "component setting" + (String)nameStr));
            return false;
        }
        return true;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Long getLong(String name) {
        Long value = (Long)this.map.get(name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getLong(name);
        }
        return value;
    }

    @Override
    public String getString(String name) {
        if (this.map.containsKey(name)) {
            return (String)this.map.get(name);
        }
        if (this.defaultSettings != null) {
            return this.defaultSettings.getString(name);
        }
        return null;
    }

    @Override
    public void setLong(String name, long value) {
        if (this.checkSetting("long", name)) {
            this.map.put(name, value);
            this.changed();
        }
    }

    @Override
    public void setString(String name, String value) {
        if (this.checkSetting("string", name)) {
            this.map.put(name, value);
            this.changed();
        }
    }

    @Override
    public void clearSetting(String name) {
        if (this.checkImmutableSetting(null, name)) {
            this.map.remove(name);
            this.changed();
        }
    }

    @Override
    public String[] getNames() {
        String[] names = new String[this.map.size()];
        int i = 0;
        for (String element : this.map.keySet()) {
            names[i++] = element;
        }
        return names;
    }

    @Override
    public Object getValue(String name) {
        Object value = this.map.get(name);
        if (value == null && this.defaultSettings != null) {
            value = this.defaultSettings.getValue(name);
        }
        return value;
    }

    @Override
    public void setValue(String name, Object value) {
        if (!this.checkSetting(null, name)) {
            return;
        }
        if (value instanceof Long || value instanceof String || value instanceof byte[]) {
            this.map.put(name, value);
            this.changed();
            return;
        }
        throw new IllegalArgumentException("Value is not a known settings type");
    }

    private void changed() {
        if (this.listener != null) {
            ChangeEvent evt = null;
            if (this.changeSourceObj != null) {
                evt = new ChangeEvent(this.changeSourceObj);
            }
            this.listener.stateChanged(evt);
        }
    }

    @Override
    public void clearAllSettings() {
        if (this.map.isEmpty()) {
            return;
        }
        if (this.checkImmutableSetting(null, null)) {
            this.map.clear();
            this.changed();
        }
    }

    public void setDefaultSettings(Settings settings) {
        this.defaultSettings = settings;
    }

    @Override
    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }
}

