/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.sourcemap;

import ghidra.framework.store.LockException;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.sourcemap.DummySourceFileManager;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.program.model.sourcemap.SourceMapEntryIterator;
import java.util.List;

public interface SourceFileManager {
    public static final SourceFileManager DUMMY = new DummySourceFileManager();

    public List<SourceMapEntry> getSourceMapEntries(Address var1);

    default public SourceMapEntry addSourceMapEntry(SourceFile sourceFile, int lineNumber, AddressRange range) throws LockException {
        try {
            return this.addSourceMapEntry(sourceFile, lineNumber, range.getMinAddress(), range.getLength());
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)"Address overflow with valid AddressRange");
        }
    }

    public SourceMapEntry addSourceMapEntry(SourceFile var1, int var2, Address var3, long var4) throws AddressOverflowException, LockException;

    public boolean intersectsSourceMapEntry(AddressSetView var1);

    public boolean addSourceFile(SourceFile var1) throws LockException;

    public boolean removeSourceFile(SourceFile var1) throws LockException;

    public boolean containsSourceFile(SourceFile var1);

    public List<SourceFile> getAllSourceFiles();

    public List<SourceFile> getMappedSourceFiles();

    public void transferSourceMapEntries(SourceFile var1, SourceFile var2) throws LockException;

    public SourceMapEntryIterator getSourceMapEntryIterator(Address var1, boolean var2);

    public List<SourceMapEntry> getSourceMapEntries(SourceFile var1, int var2, int var3);

    default public List<SourceMapEntry> getSourceMapEntries(SourceFile sourceFile, int lineNumber) {
        return this.getSourceMapEntries(sourceFile, lineNumber, lineNumber);
    }

    default public List<SourceMapEntry> getSourceMapEntries(SourceFile sourceFile) {
        return this.getSourceMapEntries(sourceFile, 0, Integer.MAX_VALUE);
    }

    public boolean removeSourceMapEntry(SourceMapEntry var1) throws LockException;
}

