/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractDimensionedArrayMsType
extends AbstractMsType {
    protected RecordNumber elementRecordNumber;
    protected RecordNumber dimensionInformationRecordNumber;
    protected String name;

    public AbstractDimensionedArrayMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.elementRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.dimensionInformationRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.name = reader.parseString(pdb, strType);
        reader.skipPadding();
    }

    public AbstractMsType getElementType() {
        return this.pdb.getTypeRecord(this.elementRecordNumber);
    }

    public RecordNumber getDimensionInformationRecordNumber() {
        return this.dimensionInformationRecordNumber;
    }

    public AbstractMsType getDimensionInformation() {
        return this.pdb.getTypeRecord(this.dimensionInformationRecordNumber);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        if (bind.ordinal() < AbstractMsType.Bind.ARRAY.ordinal()) {
            builder.insert(0, "(");
            builder.append(")");
        }
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append("<");
        myBuilder.append(this.getDimensionInformation());
        myBuilder.append(">");
        builder.append("[");
        builder.append((CharSequence)myBuilder);
        builder.append("]");
        this.getElementType().emit(builder, AbstractMsType.Bind.ARRAY);
    }
}

