/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.actions.AbstractFindReferencesToFieldAction;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.services.FieldMatcher;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Enum;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class FindReferencesToFieldByNameOrOffsetAction
extends AbstractFindReferencesToFieldAction {
    public FindReferencesToFieldByNameOrOffsetAction(Plugin plugin) {
        super(plugin);
    }

    @Override
    protected AbstractFindReferencesToFieldAction.DataTypeAndFields getSelectedType(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dtNode = (DataTypeNode)node;
        DataType dt = dtNode.getDataType();
        if (!(dt instanceof Composite) && !(dt instanceof Enum)) {
            return null;
        }
        String[] fields = null;
        if (dt instanceof Composite) {
            fields = this.getCompositeFieldNames((Composite)dt);
        } else if (dt instanceof Enum) {
            fields = ((Enum)dt).getNames();
        }
        return new AbstractFindReferencesToFieldAction.DataTypeAndFields(dt, fields);
    }

    @Override
    protected FieldMatcher createFieldMatcher(AbstractFindReferencesToFieldAction.DataTypeAndFields typeAndFields) {
        DataType dt = typeAndFields.dataType();
        String message = "Find uses of '" + dt.getName() + "' field by name or offset";
        String userChoice = OptionDialog.showEditableInputChoiceDialog(null, (String)"Choose Field", (String)message, (String[])typeAndFields.fieldNames(), null, (int)3);
        if (userChoice == null) {
            return null;
        }
        try {
            return new FieldMatcher(dt, NumericUtilities.parseInt((String)userChoice));
        }
        catch (NumberFormatException e) {
            return new FieldMatcher(dt, userChoice);
        }
    }

    private String[] getCompositeFieldNames(Composite composite) {
        DataTypeComponent[] components = composite.getDefinedComponents();
        ArrayList<String> names = new ArrayList<String>();
        for (DataTypeComponent dataTypeComponent : components) {
            String fieldName;
            if (dataTypeComponent.isBitFieldComponent() || StringUtils.isBlank((CharSequence)(fieldName = dataTypeComponent.getFieldName()))) continue;
            names.add(fieldName);
        }
        return (String[])names.toArray(String[]::new);
    }
}

