/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomSymbol
implements StructConverter {
    public static final int SIZE = 20;
    private boolean hidden;
    private boolean secondaryDef;
    private int symbolType;
    private int symbolScope;
    private int checkLevel;
    private boolean mustQualify;
    private boolean initiallyFrozen;
    private boolean memoryResident;
    private boolean isCommon;
    private boolean dupCommon;
    private int xleast;
    private int argReloc;
    private String name;
    private String qualifierName;
    private boolean hasLongReturn;
    private boolean noRelocation;
    private boolean isComdat;
    private int reserved;
    private int symbolInfo;
    private long symbolValue;

    public SomSymbol(BinaryReader reader, long symbolStringsLocation) throws IOException {
        int bitfield = reader.readNextInt();
        this.argReloc = bitfield & 0x3FF;
        this.xleast = bitfield >> 10 & 3;
        this.dupCommon = (bitfield >> 12 & 1) != 0;
        this.isCommon = (bitfield >> 13 & 1) != 0;
        this.memoryResident = (bitfield >> 14 & 1) != 0;
        this.initiallyFrozen = (bitfield >> 15 & 1) != 0;
        this.mustQualify = (bitfield >> 16 & 1) != 0;
        this.checkLevel = bitfield >> 17 & 7;
        this.symbolScope = bitfield >> 20 & 0xF;
        this.symbolType = bitfield >> 24 & 0x3F;
        this.secondaryDef = (bitfield >> 30 & 1) != 0;
        this.hidden = (bitfield >> 31 & 1) != 0;
        this.name = reader.readAsciiString(symbolStringsLocation + reader.readNextUnsignedInt());
        this.qualifierName = reader.readAsciiString(symbolStringsLocation + reader.readNextUnsignedInt());
        bitfield = reader.readNextInt();
        this.symbolInfo = bitfield & 0xFFFFFF;
        this.reserved = bitfield >> 24 & 0x1F;
        this.isComdat = (bitfield >> 29 & 1) != 0;
        this.noRelocation = (bitfield >> 30 & 1) != 0;
        this.hasLongReturn = (bitfield >> 31 & 1) != 0;
        this.symbolValue = reader.readNextUnsignedInt();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isSecondaryDef() {
        return this.secondaryDef;
    }

    public int getSymbolType() {
        return this.symbolType;
    }

    public int getSymbolScope() {
        return this.symbolScope;
    }

    public int getCheckLevel() {
        return this.checkLevel;
    }

    public boolean mustQualify() {
        return this.mustQualify;
    }

    public boolean isInitiallyFrozen() {
        return this.initiallyFrozen;
    }

    public boolean isMemoryResident() {
        return this.memoryResident;
    }

    public boolean isCommon() {
        return this.isCommon;
    }

    public boolean isDupCommon() {
        return this.dupCommon;
    }

    public int getXleast() {
        return this.xleast;
    }

    public int getArgReloc() {
        return this.argReloc;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifierName() {
        return this.qualifierName;
    }

    public boolean hasLongReturn() {
        return this.hasLongReturn;
    }

    public boolean hasNoRelocation() {
        return this.noRelocation;
    }

    public boolean isComdat() {
        return this.isComdat;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getSymbolInfo() {
        return this.symbolInfo;
    }

    public long getSymbolValue() {
        return this.symbolValue;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("symbol_dictionary_record", 20);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(DWORD, 1, "hidden", null);
            struct.addBitField(DWORD, 1, "secondary_def", null);
            struct.addBitField(DWORD, 6, "symbol_type", null);
            struct.addBitField(DWORD, 4, "symbol_scope", null);
            struct.addBitField(DWORD, 3, "check_level", null);
            struct.addBitField(DWORD, 1, "must_qualify", null);
            struct.addBitField(DWORD, 1, "initially_frozen", null);
            struct.addBitField(DWORD, 1, "memory_resident", null);
            struct.addBitField(DWORD, 1, "is_common", null);
            struct.addBitField(DWORD, 1, "dup_common", null);
            struct.addBitField(DWORD, 2, "xleast", null);
            struct.addBitField(DWORD, 10, "arg_reloc", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(DWORD, "name", null);
        struct.add(DWORD, "qualifier_name", null);
        try {
            struct.addBitField(DWORD, 1, "has_long_return", null);
            struct.addBitField(DWORD, 1, "no_relocation", null);
            struct.addBitField(DWORD, 1, "is_comdat", null);
            struct.addBitField(DWORD, 5, "reserved", null);
            struct.addBitField(DWORD, 24, "symbol_info", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(DWORD, "symbol_value", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }

    public String toString() {
        return "name=%s, type=%d, scope=%d, value = 0x%x".formatted(this.name, this.symbolType, this.symbolScope, this.symbolValue);
    }
}

