/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.data;

import db.DBHandle;
import db.Transaction;
import db.util.ErrorHandler;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainFile;
import ghidra.program.database.data.ProgramBasedDataTypeManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.database.guest.DBTracePlatformManager;
import ghidra.trace.database.guest.InternalTracePlatform;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceDataTypeManager
extends ProgramBasedDataTypeManagerDB
implements TraceBasedDataTypeManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final InternalTracePlatform platform;

    private static String computePrefix(InternalTracePlatform platform) {
        InternalTracePlatform internalTracePlatform = platform;
        Objects.requireNonNull(internalTracePlatform);
        InternalTracePlatform internalTracePlatform2 = internalTracePlatform;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DBTracePlatformManager.DBTraceHostPlatform.class, DBTraceGuestPlatform.class}, (Object)internalTracePlatform2, n)) {
            case 0 -> {
                DBTracePlatformManager.DBTraceHostPlatform host = (DBTracePlatformManager.DBTraceHostPlatform)internalTracePlatform2;
                yield null;
            }
            case 1 -> {
                DBTraceGuestPlatform guest = (DBTraceGuestPlatform)internalTracePlatform2;
                yield "Guest%d_".formatted(guest.getIntKey());
            }
            default -> throw new AssertionError();
        };
    }

    public DBTraceDataTypeManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, InternalTracePlatform platform) throws CancelledException, VersionException, IOException {
        super(dbh, null, openMode, DBTraceDataTypeManager.computePrefix(platform), (ErrorHandler)trace, trace.getLock(), monitor);
        this.lock = lock;
        this.trace = trace;
        this.platform = platform;
        this.setProgramArchitecture(platform, null, false, monitor);
        if (openMode == OpenMode.CREATE) {
            this.saveDataOrganization();
        }
    }

    protected void dataSettingChanged(Address address) {
    }

    public boolean allowsDefaultBuiltInSettings() {
        return true;
    }

    @Override
    public void invalidateCache(boolean all) {
        super.invalidateCache();
    }

    public String getName() {
        return this.trace.getName();
    }

    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name must be at least one character long: " + name);
        }
        this.trace.setName(name);
        this.categoryRenamed(CategoryPath.ROOT, this.getCategory(CategoryPath.ROOT));
    }

    @Override
    public InternalTracePlatform getPlatform() {
        return this.platform;
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        super.sourceArchiveChanged(sourceArchiveID);
        this.trace.sourceArchiveChanged(sourceArchiveID);
    }

    protected void sourceArchiveAdded(UniversalID sourceArchiveID) {
        super.sourceArchiveAdded(sourceArchiveID);
        this.trace.sourceArchiveAdded(sourceArchiveID);
    }

    public void dataTypeChanged(DataType dataType, boolean isAutoChange) {
        super.dataTypeChanged(dataType, isAutoChange);
        if (!this.isCreatingDataType()) {
            this.trace.getCodeManager().invalidateCache(false);
            this.trace.getSymbolManager().invalidateCache(false);
            this.trace.dataTypeChanged(this.getID(dataType), dataType);
        }
    }

    protected void dataTypeAdded(DataType addedType, DataType sourceType) {
        super.dataTypeAdded(addedType, sourceType);
        this.trace.dataTypeAdded(this.getID(addedType), addedType);
    }

    protected void dataTypeReplaced(long replacedID, DataTypePath replacedPath, DataType replacementType) {
        super.dataTypeReplaced(replacedID, replacedPath, replacementType);
        this.trace.dataTypeReplaced(replacedID, replacedPath, replacementType.getDataTypePath());
    }

    protected void dataTypeMoved(DataType type, DataTypePath oldPath, DataTypePath newPath) {
        super.dataTypeMoved(type, oldPath, newPath);
        this.trace.dataTypeMoved(this.getID(type), oldPath, newPath);
    }

    protected void dataTypeNameChanged(DataType type, String oldName) {
        super.dataTypeNameChanged(type, oldName);
        this.trace.dataTypeNameChanged(this.getID(type), oldName, type.getName());
    }

    protected void dataTypeDeleted(long deletedID, DataTypePath deletedPath) {
        super.dataTypeDeleted(deletedID, deletedPath);
        this.trace.dataTypeDeleted(deletedID, deletedPath);
    }

    protected void categoryCreated(Category createdCategory) {
        super.categoryCreated(createdCategory);
        this.trace.categoryAdded(createdCategory.getID(), createdCategory);
    }

    protected void categoryMoved(CategoryPath oldPath, Category category) {
        super.categoryMoved(oldPath, category);
        this.trace.categoryMoved(category.getID(), oldPath, category.getCategoryPath());
    }

    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        super.categoryRenamed(oldPath, category);
        this.trace.categoryRenamed(category.getID(), oldPath.getName(), category.getName());
    }

    protected void categoryRemoved(Category parent, String name, long deletedID) {
        super.categoryRemoved(parent, name, deletedID);
        this.trace.categoryDeleted(deletedID, new CategoryPath(parent.getCategoryPath(), new String[]{name}));
    }

    protected void replaceDataTypesUsed(Map<Long, Long> dataTypeReplacementMap) {
        this.trace.getCodeManager().replaceDataTypes(dataTypeReplacementMap);
        this.trace.getSymbolManager().replaceDataTypes(dataTypeReplacementMap);
    }

    protected void deleteDataTypesUsed(Set<Long> deletedIds) {
        this.trace.getCodeManager().clearData(deletedIds, TaskMonitor.DUMMY);
        this.trace.getSymbolManager().invalidateCache(false);
    }

    public boolean isUpdatable() {
        return this.trace.isChangeable();
    }

    public Transaction openTransaction(String description) throws IllegalStateException {
        return this.trace.openTransaction(description);
    }

    public int startTransaction(String description) {
        return this.trace.startTransaction(description);
    }

    public void flushEvents() {
        this.trace.flushEvents();
    }

    public boolean endTransaction(int transactionID, boolean commit) {
        return this.trace.endTransaction(transactionID, commit);
    }

    public void close() {
    }

    @Override
    public DBTrace getTrace() {
        return this.trace;
    }

    public DomainFile getDomainFile() {
        return this.trace.getDomainFile();
    }

    protected String getDomainFileID() {
        DomainFile domainFile = this.trace.getDomainFile();
        return domainFile == null ? null : domainFile.getFileID();
    }

    public String getPath() {
        DomainFile domainFile = this.trace.getDomainFile();
        return domainFile == null ? null : domainFile.getPathname();
    }

    public ArchiveType getType() {
        return ArchiveType.PROGRAM;
    }
}

