/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;

public class StringStringable
extends Stringable {
    public static final String SHORT_NAME = "STR";
    private static final String EMPTY_STRING = "";
    private String value;

    public StringStringable() {
        this(null);
    }

    public StringStringable(String string) {
        super(SHORT_NAME);
        this.value = string;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public String getDisplayString() {
        return this.value != null ? this.value : EMPTY_STRING;
    }

    @Override
    protected String doConvertToString(Program program) {
        if (this.value == null) {
            return EMPTY_STRING;
        }
        return this.value;
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        if (EMPTY_STRING.equals(string)) {
            this.value = null;
            return;
        }
        this.value = string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StringStringable other = (StringStringable)obj;
        return SystemUtilities.isEqual((Object)this.value, (Object)other.value);
    }
}

