/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.ContextRegisterInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextRegisterExtent {
    private Set<String> contextRegisters = new HashSet<String>();
    private Map<String, Set<BigInteger>> regsToValues = new HashMap<String, Set<BigInteger>>();

    public void addContextInfo(List<ContextRegisterInfo> contextRegisterInfo) {
        if (contextRegisterInfo == null || contextRegisterInfo.isEmpty()) {
            return;
        }
        for (ContextRegisterInfo cRegInfo : contextRegisterInfo) {
            this.addRegisterAndValue(cRegInfo.getContextRegister(), cRegInfo.getValue());
        }
    }

    private void addRegisterAndValue(String register, BigInteger value) {
        if (!this.contextRegisters.contains(register)) {
            this.contextRegisters.add(register);
            HashSet valueSet = new HashSet();
            this.regsToValues.put(register, valueSet);
        }
        this.regsToValues.get(register).add(value);
    }

    public List<String> getContextRegisters() {
        ArrayList<String> contextRegisterList = new ArrayList<String>(this.contextRegisters.size());
        contextRegisterList.addAll(this.contextRegisters);
        Collections.sort(contextRegisterList);
        return contextRegisterList;
    }

    public List<BigInteger> getValuesForRegister(String register) {
        ArrayList<BigInteger> valuesList = new ArrayList<BigInteger>();
        Set<BigInteger> values = this.regsToValues.get(register);
        if (register != null && values != null) {
            valuesList.addAll(values);
            Collections.sort(valuesList);
        }
        return valuesList;
    }

    public String toString() {
        if (this.getContextRegisters().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<String> registers = this.getContextRegisters();
        for (String register : registers) {
            sb.append("Register: ");
            sb.append(register);
            sb.append("\n");
            sb.append("Values: ");
            List<BigInteger> values = this.getValuesForRegister(register);
            for (int i = 0; i < values.size(); ++i) {
                sb.append(values.get(i));
                if (i != values.size() - 1) {
                    sb.append(", ");
                    continue;
                }
                sb.append("\n\n");
            }
        }
        return sb.toString();
    }
}

