/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class Helper {
    public static Timeout getLockTimeout(String sql, TimeoutExtractor extractor, Connection connection, SessionFactoryImplementor factory) {
        Timeout timeout;
        block9: {
            Statement statement = connection.createStatement();
            try {
                factory.getJdbcServices().getSqlStatementLogger().logStatement(sql);
                ResultSet results = statement.executeQuery(sql);
                if (!results.next()) {
                    throw new HibernateException("Unable to query JDBC Connection for current lock-timeout setting (no result)");
                }
                timeout = extractor.extractFrom(results);
                if (statement == null) break block9;
            }
            catch (Throwable results) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            results.addSuppressed(throwable);
                        }
                    }
                    throw results;
                }
                catch (SQLException sqle) {
                    SqlExceptionHelper sqlExceptionHelper = factory.getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper();
                    throw sqlExceptionHelper.convert(sqle, "Unable to query JDBC Connection for current lock-timeout setting");
                }
            }
            statement.close();
        }
        return timeout;
    }

    public static void setLockTimeout(Timeout timeout, Function<Timeout, Integer> valueStrategy, String sqlFormat, Connection connection, SessionFactoryImplementor factory) {
        int milliseconds = valueStrategy.apply(timeout);
        String sql = String.format(sqlFormat, milliseconds);
        try (Statement statement = connection.createStatement();){
            factory.getJdbcServices().getSqlStatementLogger().logStatement(sql);
            statement.execute(sql);
        }
        catch (SQLException sqle) {
            SqlExceptionHelper sqlExceptionHelper = factory.getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper();
            throw sqlExceptionHelper.convert(sqle, "Unable to set lock-timeout setting on JDBC connection");
        }
    }

    @FunctionalInterface
    public static interface TimeoutExtractor {
        public Timeout extractFrom(ResultSet var1) throws SQLException;
    }
}

