/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.List;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.partialimport.AbstractPartialImport;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;

public class IdentityProviderMappersPartialImport
extends AbstractPartialImport<IdentityProviderMapperRepresentation> {
    @Override
    public List<IdentityProviderMapperRepresentation> getRepList(PartialImportRepresentation partialImportRep) {
        return partialImportRep.getIdentityProviderMappers();
    }

    @Override
    public String getName(IdentityProviderMapperRepresentation idpMapperRep) {
        return idpMapperRep.getName();
    }

    @Override
    public String getModelId(RealmModel realm, KeycloakSession session, IdentityProviderMapperRepresentation idpMapperRep) {
        return session.identityProviders().getMapperByName(idpMapperRep.getIdentityProviderAlias(), idpMapperRep.getName()).getId();
    }

    @Override
    public boolean exists(RealmModel realm, KeycloakSession session, IdentityProviderMapperRepresentation idpMapperRep) {
        return session.identityProviders().getMapperByName(idpMapperRep.getIdentityProviderAlias(), idpMapperRep.getName()) != null;
    }

    @Override
    public String existsMessage(RealmModel realm, IdentityProviderMapperRepresentation idpMapperRep) {
        return "Identity Provider Mapper'" + this.getName(idpMapperRep) + "' already exists.";
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.IDP_MAPPER;
    }

    @Override
    public void remove(RealmModel realm, KeycloakSession session, IdentityProviderMapperRepresentation idpMapperRep) {
        IdentityProviderMapperModel idpMapper = session.identityProviders().getMapperByName(idpMapperRep.getIdentityProviderAlias(), idpMapperRep.getName());
        if (idpMapper != null) {
            session.identityProviders().removeMapper(idpMapper);
        }
    }

    @Override
    public void create(RealmModel realm, KeycloakSession session, IdentityProviderMapperRepresentation idpMapperRep) {
        IdentityProviderMapperModel existing = session.identityProviders().getMapperByName(idpMapperRep.getIdentityProviderAlias(), idpMapperRep.getName());
        if (existing != null) {
            session.identityProviders().removeMapper(existing);
        }
        IdentityProviderMapperModel idpMapper = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)idpMapperRep);
        session.identityProviders().createMapper(idpMapper);
    }
}

