/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.security.Key;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

public class FIPSAesKeyWrapAlgorithmProvider
implements JWEAlgorithmProvider {
    public byte[] decodeCek(byte[] encodedCek, Key encryptionKey, JWEHeader header, JWEEncryptionProvider encryptionProvider) throws Exception {
        byte[] keyBytes = encryptionKey.getEncoded();
        SymmetricSecretKey aesKey = new SymmetricSecretKey((Parameters)FipsAES.KW, keyBytes);
        FipsAES.KeyWrapOperatorFactory factory = new FipsAES.KeyWrapOperatorFactory();
        FipsKeyUnwrapper unwrapper = factory.createKeyUnwrapper((SymmetricKey)aesKey, FipsAES.KW);
        return unwrapper.unwrap(encodedCek, 0, encodedCek.length);
    }

    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key encryptionKey, JWEHeader.JWEHeaderBuilder headerBuilder) throws Exception {
        byte[] inputKeyBytes = keyStorage.getCekBytes();
        byte[] keyBytes = encryptionKey.getEncoded();
        SymmetricSecretKey aesKey = new SymmetricSecretKey((Parameters)FipsAES.KW, keyBytes);
        FipsAES.KeyWrapOperatorFactory factory = new FipsAES.KeyWrapOperatorFactory();
        FipsKeyWrapper wrapper = factory.createKeyWrapper((SymmetricKey)aesKey, FipsAES.KW);
        return wrapper.wrap(inputKeyBytes, 0, inputKeyBytes.length);
    }
}

