/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.telemetry.Telemetry;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.telemetry.metrics.DefaultMetricsRegistry;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.MetricsTelemetry;
import org.opensearch.telemetry.metrics.noop.NoopMetricsRegistry;

@InternalApi
public class MetricsRegistryFactory
implements Closeable {
    private static final Logger logger = LogManager.getLogger(MetricsRegistryFactory.class);
    private final TelemetrySettings telemetrySettings;
    private final MetricsRegistry metricsRegistry;

    public MetricsRegistryFactory(TelemetrySettings telemetrySettings, Optional<Telemetry> telemetry) {
        this.telemetrySettings = telemetrySettings;
        this.metricsRegistry = this.metricsRegistry(telemetry);
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @Override
    public void close() {
        try {
            this.metricsRegistry.close();
        }
        catch (IOException e) {
            logger.warn("Error closing MetricsRegistry", (Throwable)e);
        }
    }

    private MetricsRegistry metricsRegistry(Optional<Telemetry> telemetry) {
        MetricsRegistry metricsRegistry = telemetry.map(Telemetry::getMetricsTelemetry).map(metricsTelemetry -> this.createDefaultMetricsRegistry((MetricsTelemetry)metricsTelemetry)).orElse((MetricsRegistry)NoopMetricsRegistry.INSTANCE);
        return metricsRegistry;
    }

    private MetricsRegistry createDefaultMetricsRegistry(MetricsTelemetry metricsTelemetry) {
        return new DefaultMetricsRegistry(metricsTelemetry);
    }
}

