/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.GarbageCollectorTotal;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GarbageCollector
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GarbageCollector> {
    @Nonnull
    private final Map<String, GarbageCollectorTotal> collectors;
    public static final JsonpDeserializer<GarbageCollector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollector::setupGarbageCollectorDeserializer);

    private GarbageCollector(Builder builder) {
        this.collectors = ApiTypeHelper.unmodifiable(builder.collectors);
    }

    public static GarbageCollector of(Function<Builder, ObjectBuilder<GarbageCollector>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, GarbageCollectorTotal> collectors() {
        return this.collectors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.collectors)) {
            generator.writeKey("collectors");
            generator.writeStartObject();
            for (Map.Entry<String, GarbageCollectorTotal> item0 : this.collectors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGarbageCollectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectors, JsonpDeserializer.stringMapDeserializer(GarbageCollectorTotal._DESERIALIZER), "collectors");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.collectors);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GarbageCollector other = (GarbageCollector)o;
        return Objects.equals(this.collectors, other.collectors);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GarbageCollector> {
        @Nullable
        private Map<String, GarbageCollectorTotal> collectors;

        public Builder() {
        }

        private Builder(GarbageCollector o) {
            this.collectors = Builder._mapCopy(o.collectors);
        }

        private Builder(Builder o) {
            this.collectors = Builder._mapCopy(o.collectors);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder collectors(Map<String, GarbageCollectorTotal> map) {
            this.collectors = Builder._mapPutAll(this.collectors, map);
            return this;
        }

        @Nonnull
        public final Builder collectors(String key, GarbageCollectorTotal value) {
            this.collectors = Builder._mapPut(this.collectors, key, value);
            return this;
        }

        @Nonnull
        public final Builder collectors(String key, Function<GarbageCollectorTotal.Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
            return this.collectors(key, fn.apply(new GarbageCollectorTotal.Builder()).build());
        }

        @Override
        @Nonnull
        public GarbageCollector build() {
            this._checkSingleUse();
            return new GarbageCollector(this);
        }
    }
}

