/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceExample;

public abstract class SequenceModel<T extends Output<T>>
implements Provenancable<ModelProvenance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    private final ModelProvenance provenance;
    protected final String provenanceOutput;
    protected final ImmutableFeatureMap featureIDMap;
    protected final ImmutableOutputInfo<T> outputIDMap;

    public SequenceModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDMap) {
        this.name = name;
        this.provenance = provenance;
        this.provenanceOutput = provenance.toString();
        this.featureIDMap = featureIDMap;
        this.outputIDMap = outputIDMap;
    }

    public boolean validate(Class<? extends Output<?>> clazz) {
        Set domain = this.outputIDMap.getDomain();
        boolean output = true;
        for (Output type : domain) {
            output &= clazz.isInstance(type);
        }
        return output;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name + " - " + this.provenanceOutput;
        }
        return this.provenanceOutput;
    }

    public ImmutableFeatureMap getFeatureIDMap() {
        return this.featureIDMap;
    }

    public ImmutableOutputInfo<T> getOutputIDInfo() {
        return this.outputIDMap;
    }

    public abstract List<Prediction<T>> predict(SequenceExample<T> var1);

    public List<List<Prediction<T>>> predict(Iterable<SequenceExample<T>> examples) {
        ArrayList<List<Prediction<T>>> predictions = new ArrayList<List<Prediction<T>>>();
        for (SequenceExample<T> example : examples) {
            predictions.add(this.predict(example));
        }
        return predictions;
    }

    public List<List<Prediction<T>>> predict(SequenceDataset<T> examples) {
        ArrayList<List<Prediction<T>>> predictions = new ArrayList<List<Prediction<T>>>();
        for (SequenceExample<T> example : examples) {
            predictions.add(this.predict(example));
        }
        return predictions;
    }

    public abstract Map<String, List<Pair<String, Double>>> getTopFeatures(int var1);

    public static <T extends Output<T>> List<T> toMaxLabels(List<Prediction<T>> predictions) {
        return predictions.stream().map(Prediction::getOutput).collect(Collectors.toList());
    }
}

