/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterProcessor
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterProcessor> {
    private final long count;
    private final long current;
    private final long failed;
    @Nullable
    private final Time time;
    private final long timeInMillis;
    public static final JsonpDeserializer<ClusterProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterProcessor::setupClusterProcessorDeserializer);

    private ClusterProcessor(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.time = builder.time;
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
    }

    public static ClusterProcessor of(Function<Builder, ObjectBuilder<ClusterProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long current() {
        return this.current;
    }

    public final long failed() {
        return this.failed;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("failed");
        generator.write(this.failed);
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::time, Time._DESERIALIZER, "time");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.count);
        result = 31 * result + Long.hashCode(this.current);
        result = 31 * result + Long.hashCode(this.failed);
        result = 31 * result + Objects.hashCode(this.time);
        result = 31 * result + Long.hashCode(this.timeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterProcessor other = (ClusterProcessor)o;
        return this.count == other.count && this.current == other.current && this.failed == other.failed && Objects.equals(this.time, other.time) && this.timeInMillis == other.timeInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterProcessor> {
        private Long count;
        private Long current;
        private Long failed;
        @Nullable
        private Time time;
        private Long timeInMillis;

        public Builder() {
        }

        private Builder(ClusterProcessor o) {
            this.count = o.count;
            this.current = o.current;
            this.failed = o.failed;
            this.time = o.time;
            this.timeInMillis = o.timeInMillis;
        }

        private Builder(Builder o) {
            this.count = o.count;
            this.current = o.current;
            this.failed = o.failed;
            this.time = o.time;
            this.timeInMillis = o.timeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        @Nonnull
        public final Builder failed(long value) {
            this.failed = value;
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        @Nonnull
        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterProcessor build() {
            this._checkSingleUse();
            return new ClusterProcessor(this);
        }
    }
}

