/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.BitBackedSetImpl;
import com.selectivem.collections.ImmutableCompactSubSet;
import com.selectivem.collections.ImmutableCompactSubSetImpl;
import com.selectivem.collections.IndexedImmutableSetImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DeduplicatingCompactSubSetBuilder<E> {
    private final IndexedImmutableSetImpl<E> candidateElements;
    private final int bitArraySize;
    private E currentElement;
    private int currentElementIndex;
    private BackingBitSetBuilder<E> backingCollectionWithCurrentElementOnly = null;
    private List<SubSetBuilder<E>> subSetBuilders = new ArrayList<SubSetBuilder<E>>();
    private List<BackingBitSetBuilder<E>> backingBitSets = new ArrayList<BackingBitSetBuilder<E>>();
    private int estimatedBackingArraySize = 0;
    private int estimatedObjectOverheadSize = 0;

    public DeduplicatingCompactSubSetBuilder(Set<E> superSet) {
        this.candidateElements = IndexedImmutableSetImpl.of(superSet);
        this.bitArraySize = BitBackedSetImpl.bitArraySize(superSet.size());
    }

    public SubSetBuilder<E> createSubSetBuilder() {
        SubSetBuilder result = new SubSetBuilder(this);
        this.subSetBuilders.add(result);
        return result;
    }

    public void next(E candidateElement) {
        int currentElementIndex;
        E prevElement = this.currentElement;
        int prevElementIndex = this.currentElementIndex;
        if (this.currentElement != null) {
            this.finishCurrentElement();
        }
        if ((currentElementIndex = this.candidateElements.elementToIndex((Object)candidateElement)) == -1) {
            throw new IllegalArgumentException("Element " + candidateElement + " is not part of super set " + this.candidateElements);
        }
        if (prevElement != null && currentElementIndex <= prevElementIndex) {
            throw new IllegalArgumentException("Element " + candidateElement + " comes in the iteration order of the super set before " + prevElement + " (" + currentElementIndex + " < " + prevElementIndex + ");You must follow the iteration order of the super set specified in the constructor.");
        }
        this.currentElement = candidateElement;
        this.currentElementIndex = currentElementIndex;
    }

    public Completed<E> build() {
        this.finishCurrentElement();
        return new Completed(this);
    }

    public int getEstimatedByteSize() {
        return this.estimatedBackingArraySize + this.estimatedObjectOverheadSize;
    }

    int validateCurrentElement(E candidateElement) {
        if (this.currentElement != null) {
            if (!candidateElement.equals(this.currentElement)) {
                throw new IllegalStateException("Trying to add an element which is not the current element; candidateElement: " + candidateElement + "; currentElement: " + this.currentElement);
            }
            return this.currentElementIndex;
        }
        throw new IllegalStateException("next() must be called before an element can be added");
    }

    void finishCurrentElement() {
        if (this.currentElement == null) {
            return;
        }
        for (SubSetBuilder<E> subSetBuilder : this.subSetBuilders) {
            subSetBuilder.finish(this.currentElement);
        }
        for (BackingBitSetBuilder backingBitSetBuilder : this.backingBitSets) {
            backingBitSetBuilder.finish(this.currentElement);
        }
        this.currentElement = null;
        this.backingCollectionWithCurrentElementOnly = null;
    }

    static final class BackingBitSetBuilder<E> {
        private E offeredElement;
        private int offeredElementIndex = -1;
        private long[] bits;
        private int size;
        private final IndexedImmutableSetImpl<E> elementToIndexMap;
        private final int bitArrayOffset;
        private BackingBitSetBuilder<E> copyWithNone;
        private final DeduplicatingCompactSubSetBuilder<E> root;
        private ImmutableCompactSubSet<E> finalBuildResult;
        private E firstElement;

        BackingBitSetBuilder(E element, int elementIndex, DeduplicatingCompactSubSetBuilder<E> root) {
            int arrayIndex;
            this.elementToIndexMap = ((DeduplicatingCompactSubSetBuilder)root).candidateElements;
            this.firstElement = element;
            this.size = 1;
            long bit = 1L << (elementIndex & 0x3F);
            this.bitArrayOffset = arrayIndex = elementIndex >> 6;
            this.bits = new long[((DeduplicatingCompactSubSetBuilder)root).bitArraySize - this.bitArrayOffset];
            this.bits[0] = bit;
            this.root = root;
            ((DeduplicatingCompactSubSetBuilder)root).backingBitSets.add(this);
            ((DeduplicatingCompactSubSetBuilder)root).estimatedBackingArraySize += this.bits.length * 8;
            ((DeduplicatingCompactSubSetBuilder)root).estimatedObjectOverheadSize += 36;
        }

        BackingBitSetBuilder(BackingBitSetBuilder<E> original) {
            this.elementToIndexMap = original.elementToIndexMap;
            this.firstElement = original.firstElement;
            this.bits = new long[original.bits.length];
            this.size = original.size;
            this.bitArrayOffset = original.bitArrayOffset;
            System.arraycopy(original.bits, 0, this.bits, 0, original.bits.length);
            this.root = original.root;
            ((DeduplicatingCompactSubSetBuilder)this.root).backingBitSets.add(this);
            ((DeduplicatingCompactSubSetBuilder)this.root).estimatedBackingArraySize += this.bits.length * 8;
            ((DeduplicatingCompactSubSetBuilder)this.root).estimatedObjectOverheadSize += 36;
        }

        BackingBitSetBuilder<E> branchOff() {
            if (this.copyWithNone == null) {
                this.copyWithNone = this.copy();
                return this.copyWithNone;
            }
            return this.copyWithNone;
        }

        void finish(E element) {
            this.addOfferedElement();
            this.copyWithNone = null;
        }

        void offerElement(E offeredElement, int offeredElementIndex) {
            this.offeredElement = offeredElement;
            this.offeredElementIndex = offeredElementIndex;
        }

        void addOfferedElement() {
            if (this.offeredElement == null) {
                return;
            }
            try {
                if (BitBackedSetImpl.setBit(this.bits, this.offeredElementIndex, this.bitArrayOffset)) {
                    ++this.size;
                    if (this.firstElement == null) {
                        this.firstElement = this.offeredElement;
                    }
                }
            }
            finally {
                this.offeredElement = null;
                this.offeredElementIndex = -1;
            }
        }

        BackingBitSetBuilder<E> copy() {
            return new BackingBitSetBuilder<E>(this);
        }

        ImmutableCompactSubSet<E> build() {
            if (this.finalBuildResult != null) {
                return this.finalBuildResult;
            }
            if (this.size == this.elementToIndexMap.size()) {
                this.finalBuildResult = ImmutableCompactSubSetImpl.of(this.elementToIndexMap);
            } else if (this.size == 1) {
                this.finalBuildResult = ImmutableCompactSubSetImpl.of(IndexedImmutableSetImpl.of(this.firstElement));
            } else {
                long[] bits = this.bits;
                int lastNonZeroIndex = BitBackedSetImpl.lastNonZeroIndex(bits);
                if (lastNonZeroIndex <= 0) {
                    this.finalBuildResult = new BitBackedSetImpl.LongBacked<E>(bits[0], this.size, this.elementToIndexMap, this.bitArrayOffset);
                } else {
                    if (lastNonZeroIndex != bits.length - 1) {
                        long[] shortenedBits = new long[lastNonZeroIndex + 1];
                        System.arraycopy(bits, 0, shortenedBits, 0, shortenedBits.length);
                        bits = shortenedBits;
                    }
                    this.finalBuildResult = new BitBackedSetImpl.LongArrayBacked<E>(bits, this.size, this.elementToIndexMap, this.bitArrayOffset);
                }
            }
            return this.finalBuildResult;
        }
    }

    public static class SubSetBuilder<E> {
        private final DeduplicatingCompactSubSetBuilder<E> root;
        private int size = 0;
        private BackingBitSetBuilder<E> backingCollection;
        private E lastAddedElement;

        SubSetBuilder(DeduplicatingCompactSubSetBuilder<E> root) {
            this.root = root;
        }

        public void add(E element) {
            int elementIndex = this.root.validateCurrentElement(element);
            if (this.size == 0) {
                this.backingCollection = ((DeduplicatingCompactSubSetBuilder)this.root).backingCollectionWithCurrentElementOnly != null ? ((DeduplicatingCompactSubSetBuilder)this.root).backingCollectionWithCurrentElementOnly : (((DeduplicatingCompactSubSetBuilder)this.root).backingCollectionWithCurrentElementOnly = new BackingBitSetBuilder<E>(element, elementIndex, this.root));
                this.size = 1;
            } else {
                this.backingCollection.offerElement(element, elementIndex);
                ++this.size;
            }
            this.lastAddedElement = element;
        }

        public ImmutableCompactSubSet<E> build(Completed<E> completed) {
            if (((Completed)completed).root != this.root) {
                throw new IllegalArgumentException("Called for the wrong DeduplicatingCompactSubSetBuilder");
            }
            if (this.backingCollection == null) {
                return ImmutableCompactSubSetImpl.empty();
            }
            return this.backingCollection.build();
        }

        void finish(E element) {
            if (this.backingCollection == null) {
                return;
            }
            if (!element.equals(this.lastAddedElement) && ((BackingBitSetBuilder)this.backingCollection).offeredElement != null) {
                this.backingCollection = this.backingCollection.branchOff();
            }
        }
    }

    public static class Completed<E> {
        private final DeduplicatingCompactSubSetBuilder<E> root;

        Completed(DeduplicatingCompactSubSetBuilder<E> root) {
            this.root = root;
        }
    }
}

