/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.classic;

import java.util.Map;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.classic.ClassicTokenizer;
import org.apache.lucene.util.AttributeFactory;

public class ClassicTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "classic";
    private final int maxTokenLength;

    public ClassicTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxTokenLength = this.getInt(args, "maxTokenLength", 255);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public ClassicTokenizerFactory() {
        throw ClassicTokenizerFactory.defaultCtorException();
    }

    @Override
    public ClassicTokenizer create(AttributeFactory factory) {
        ClassicTokenizer tokenizer = new ClassicTokenizer(factory);
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

