/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstElsePart;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstIfPart;
import com.jetbrains.python.ast.PyAstTargetExpression;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareService;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareServiceClasses;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyDocumentationSettings
extends PyDefaultProjectAwareService<ServiceState, PyDocumentationSettings, AppService, ModuleService> {
    @ApiStatus.Internal
    public static final PyDefaultProjectAwareServiceClasses<ServiceState, PyDocumentationSettings, AppService, ModuleService> SERVICE_CLASSES = new PyDefaultProjectAwareServiceClasses(AppService.class, ModuleService.class);
    @ApiStatus.Internal
    public static final DocStringFormat DEFAULT_DOC_STRING_FORMAT = DocStringFormat.REST;

    protected PyDocumentationSettings() {
        super(new ServiceState());
    }

    public static PyDocumentationSettings getInstance(@Nullable Module module) {
        return SERVICE_CLASSES.getService(module);
    }

    public final boolean isNumpyFormat(PsiFile file) {
        return this.isFormat(file, DocStringFormat.NUMPY);
    }

    public final boolean isPlain(PsiFile file) {
        return this.isFormat(file, DocStringFormat.PLAIN);
    }

    private boolean isFormat(@Nullable PsiFile file, @NotNull DocStringFormat format) {
        if (format == null) {
            PyDocumentationSettings.$$$reportNull$$$0(0);
        }
        return file instanceof PyAstFile ? this.getFormatForFile(file) == format : ((ServiceState)this.getState()).getFormat() == format;
    }

    @NotNull
    public final DocStringFormat getFormatForFile(@NotNull PsiFile file) {
        DocStringFormat fileFormat;
        if (file == null) {
            PyDocumentationSettings.$$$reportNull$$$0(1);
        }
        DocStringFormat docStringFormat = (fileFormat = PyDocumentationSettings.getFormatFromDocformatAttribute(file)) != null && fileFormat != DocStringFormat.PLAIN ? fileFormat : ((ServiceState)this.getState()).myDocStringFormat;
        if (docStringFormat == null) {
            PyDocumentationSettings.$$$reportNull$$$0(2);
        }
        return docStringFormat;
    }

    @Nullable
    public static DocStringFormat getFormatFromDocformatAttribute(@NotNull PsiFile file) {
        DocStringFormat fileFormat;
        List words;
        String docformat;
        PyAstTargetExpression expr;
        if (file == null) {
            PyDocumentationSettings.$$$reportNull$$$0(3);
        }
        if (file instanceof PyAstFile && (expr = PyDocumentationSettings.getDocFormatAttribute(file)) != null && (docformat = PyPsiUtilsCore.strValue((PyAstExpression)expr.findAssignedValue())) != null && !(words = StringUtil.split((String)docformat, (String)" ")).isEmpty() && (fileFormat = DocStringFormat.fromName((String)words.get(0))) != null) {
            return fileFormat;
        }
        return null;
    }

    @Nullable
    private static PyAstTargetExpression getDocFormatAttribute(@NotNull PsiFile file) {
        StubElement stub;
        if (file == null) {
            PyDocumentationSettings.$$$reportNull$$$0(4);
        }
        if ((stub = ((PsiFileImpl)file).getGreenStub()) != null) {
            return PyDocumentationSettings.getDocFormatAttribute(stub.getChildrenStubs());
        }
        return PyDocumentationSettings.getDocFormatAttribute(file.getChildren());
    }

    @Nullable
    private static PyAstTargetExpression getDocFormatAttribute(@NotNull List<StubElement<?>> stubs) {
        if (stubs == null) {
            PyDocumentationSettings.$$$reportNull$$$0(5);
        }
        for (StubElement<?> stub : stubs) {
            PyAstTargetExpression targetExpression;
            PsiElement psi = stub.getPsi();
            if (psi instanceof PyAstTargetExpression && "__docformat__".equals((targetExpression = (PyAstTargetExpression)psi).getName())) {
                return targetExpression;
            }
            if (!(psi instanceof PyAstIfPart) && !(psi instanceof PyAstElsePart) || (targetExpression = PyDocumentationSettings.getDocFormatAttribute(stub.getChildrenStubs())) == null) continue;
            return targetExpression;
        }
        return null;
    }

    @Nullable
    private static PyAstTargetExpression getDocFormatAttribute(@NotNull @NotNull PsiElement @NotNull [] elements) {
        if (elements == null) {
            PyDocumentationSettings.$$$reportNull$$$0(6);
        }
        for (PsiElement element : elements) {
            PyAstTargetExpression targetExpression;
            if (element instanceof PyAstClass || element instanceof PyAstFunction) continue;
            if (element instanceof PyAstTargetExpression && "__docformat__".equals((targetExpression = (PyAstTargetExpression)element).getName())) {
                return targetExpression;
            }
            targetExpression = PyDocumentationSettings.getDocFormatAttribute(element.getChildren());
            if (targetExpression == null) continue;
            return targetExpression;
        }
        return null;
    }

    @NotNull
    public final DocStringFormat getFormat() {
        DocStringFormat docStringFormat = ((ServiceState)this.getState()).getFormat();
        if (docStringFormat == null) {
            PyDocumentationSettings.$$$reportNull$$$0(7);
        }
        return docStringFormat;
    }

    public final void setFormat(@NotNull DocStringFormat format) {
        if (format == null) {
            PyDocumentationSettings.$$$reportNull$$$0(8);
        }
        ((ServiceState)this.getState()).myDocStringFormat = format;
    }

    public final boolean isAnalyzeDoctest() {
        return ((ServiceState)this.getState()).myAnalyzeDoctest;
    }

    public final void setAnalyzeDoctest(boolean analyze) {
        ((ServiceState)this.getState()).myAnalyzeDoctest = analyze;
    }

    public final boolean isRenderExternalDocumentation() {
        return ((ServiceState)this.getState()).myRenderExternalDocumentation;
    }

    public final void setRenderExternalDocumentation(boolean renderExternalDocumentation) {
        ((ServiceState)this.getState()).myRenderExternalDocumentation = renderExternalDocumentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatForFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFormat";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFormatForFile";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFromDocformatAttribute";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocFormatAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }

    public static final class ServiceState {
        @NotNull
        private DocStringFormat myDocStringFormat;
        @OptionTag(value="analyzeDoctest")
        public boolean myAnalyzeDoctest;
        @OptionTag(value="renderExternalDocumentation")
        public boolean myRenderExternalDocumentation;

        @ApiStatus.Internal
        public ServiceState(@NotNull DocStringFormat docStringFormat) {
            if (docStringFormat == null) {
                ServiceState.$$$reportNull$$$0(0);
            }
            this.myAnalyzeDoctest = true;
            this.myDocStringFormat = docStringFormat;
        }

        ServiceState() {
            this(DEFAULT_DOC_STRING_FORMAT);
        }

        @NotNull
        public DocStringFormat getFormat() {
            DocStringFormat docStringFormat = this.myDocStringFormat;
            if (docStringFormat == null) {
                ServiceState.$$$reportNull$$$0(1);
            }
            return docStringFormat;
        }

        public void setFormat(@NotNull DocStringFormat format) {
            if (format == null) {
                ServiceState.$$$reportNull$$$0(2);
            }
            this.myDocStringFormat = format;
        }

        @OptionTag(value="myDocStringFormat")
        @NotNull
        public String getFormatName() {
            String string = this.myDocStringFormat.getName();
            if (string == null) {
                ServiceState.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void setFormatName(@NotNull String name) {
            if (name == null) {
                ServiceState.$$$reportNull$$$0(4);
            }
            this.myDocStringFormat = DocStringFormat.fromNameOrPlain(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docStringFormat";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationSettings$ServiceState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationSettings$ServiceState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormat";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFormatName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    @State(name="AppPyDocumentationSettings", storages={@Storage(value="PyDocumentationSettings.xml")}, category=SettingsCategory.CODE)
    public static final class AppService
    extends PyDocumentationSettings {
    }

    @State(name="PyDocumentationSettings")
    public static final class ModuleService
    extends PyDocumentationSettings {
    }
}

