/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BemEmmetFilter
extends ZenCodingFilter {
    private static final String SUFFIX = "bem";
    private static final Key<BemState> BEM_STATE = Key.create((String)"BEM_STATE");
    private static final Pattern BLOCK_NAME_PATTERN = Pattern.compile("^[A-z]-");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message("emmet.filter.BEM", new Object[0]);
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuffix() {
        return SUFFIX;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            BemEmmetFilter.$$$reportNull$$$0(1);
        }
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(2);
        }
        Map<String, String> attributes = node.getTemplateToken().getAttributes();
        String classAttributeName = "class";
        String classValue = attributes.get(classAttributeName);
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        if (classValue != null && emmetOptions != null) {
            String elementSeparator = emmetOptions.getBemElementSeparator();
            String modifierSeparator = emmetOptions.getBemModifierSeparator();
            String shortElementPrefix = emmetOptions.getBemShortElementPrefix();
            List classNames = ContainerUtil.map((Iterable)HtmlUtil.splitClassNames((String)classValue), s -> BemEmmetFilter.normalizeClassName(s, elementSeparator, shortElementPrefix));
            BEM_STATE.set((UserDataHolder)node, (Object)new BemState(BemEmmetFilter.suggestBlockName(classNames), null, null));
            LinkedHashSet newClassNames = new LinkedHashSet();
            for (String className : classNames) {
                ContainerUtil.addAll(newClassNames, BemEmmetFilter.processClassName(className, node, elementSeparator, modifierSeparator));
            }
            attributes.put(classAttributeName, StringUtil.join(newClassNames, (String)" "));
        }
        GenerationNode generationNode = node;
        if (generationNode == null) {
            BemEmmetFilter.$$$reportNull$$$0(3);
        }
        return generationNode;
    }

    private static Iterable<String> processClassName(@NotNull String className, @NotNull GenerationNode node, @NotNull String elementSeparator, @NotNull String modifierSeparator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(4);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(5);
        }
        if (elementSeparator == null) {
            BemEmmetFilter.$$$reportNull$$$0(6);
        }
        if (modifierSeparator == null) {
            BemEmmetFilter.$$$reportNull$$$0(7);
        }
        className = BemEmmetFilter.fillWithBemElements(className, node, elementSeparator);
        className = BemEmmetFilter.fillWithBemModifiers(className, node, modifierSeparator);
        BemState nodeBemState = (BemState)BEM_STATE.get((UserDataHolder)node);
        BemState bemState = BemEmmetFilter.extractBemStateFromClassName(className, elementSeparator, modifierSeparator);
        ArrayList<String> result = new ArrayList<String>();
        if (!bemState.isEmpty()) {
            String nodeBlockValue = nodeBemState != null ? nodeBemState.getBlock() : null;
            String block = bemState.getBlock();
            if (StringUtil.isEmpty((String)block)) {
                block = StringUtil.notNullize((String)nodeBlockValue);
                bemState.setBlock(block);
            }
            Object prefix = block;
            String element = bemState.getElement();
            if (StringUtil.isNotEmpty((String)element)) {
                prefix = (String)prefix + elementSeparator + element;
            }
            result.add((String)prefix);
            String modifier = bemState.getModifier();
            if (StringUtil.isNotEmpty((String)modifier)) {
                result.add((String)prefix + modifierSeparator + modifier);
            }
            BemState newNodeBemState = bemState.copy();
            if (StringUtil.isNotEmpty((String)nodeBlockValue) && StringUtil.isEmpty((String)modifier)) {
                newNodeBemState.setBlock(nodeBlockValue);
            }
            BEM_STATE.set((UserDataHolder)node, (Object)newNodeBemState);
        } else {
            result.add(className);
        }
        return result;
    }

    @NotNull
    private static BemState extractBemStateFromClassName(@NotNull String className, String elementSeparator, String modifierSeparator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(8);
        }
        BemState result = new BemState();
        int indexOfElementSeparator = className.indexOf(elementSeparator);
        if (indexOfElementSeparator >= 0) {
            result.setBlock(className.substring(0, indexOfElementSeparator));
            result.setElement(className.substring(indexOfElementSeparator + elementSeparator.length()));
            int lastIndexOfElementSeparator = className.lastIndexOf(elementSeparator);
            assert (lastIndexOfElementSeparator >= 0);
            int indexOfModifierSeparator = className.indexOf(modifierSeparator, lastIndexOfElementSeparator + elementSeparator.length());
            if (indexOfModifierSeparator >= 0) {
                result.setModifier(className.substring(indexOfModifierSeparator + modifierSeparator.length()));
                result.setElement(className.substring(indexOfElementSeparator + elementSeparator.length(), indexOfModifierSeparator));
            }
        } else {
            int indexOfModifierSeparator = className.indexOf(modifierSeparator);
            if (indexOfModifierSeparator >= 0) {
                result.setBlock(className.substring(0, indexOfModifierSeparator));
                result.setModifier(className.substring(indexOfModifierSeparator + modifierSeparator.length()));
            }
        }
        BemState bemState = result;
        if (bemState == null) {
            BemEmmetFilter.$$$reportNull$$$0(9);
        }
        return bemState;
    }

    @NotNull
    private static String fillWithBemElements(@NotNull String className, @NotNull GenerationNode node, @NotNull String separator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(10);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(11);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(12);
        }
        return BemEmmetFilter.transformClassNameToBemFormat(className, separator, node, false);
    }

    @NotNull
    private static String fillWithBemModifiers(@NotNull String className, @NotNull GenerationNode node, @NotNull String separator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(13);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(14);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(15);
        }
        return BemEmmetFilter.transformClassNameToBemFormat(className, separator, node, true);
    }

    @NotNull
    private static String transformClassNameToBemFormat(@NotNull String className, @NotNull String separator, @NotNull GenerationNode node, boolean isModifierSeparator) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(16);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(17);
        }
        if (node == null) {
            BemEmmetFilter.$$$reportNull$$$0(18);
        }
        Pair<String, Integer> cleanStringAndDepth = BemEmmetFilter.getCleanStringAndDepth(className, separator);
        Integer depth = (Integer)cleanStringAndDepth.second;
        if (depth > 0) {
            Object prefix;
            GenerationNode donor = node;
            while (donor.getParent() != null && depth > 0) {
                donor = donor.getParent();
                Integer n = depth;
                depth = depth - 1;
            }
            BemState bemState = (BemState)BEM_STATE.get((UserDataHolder)donor);
            if (bemState != null && !StringUtil.isEmpty((String)(prefix = bemState.getBlock()))) {
                String element = bemState.getElement();
                if (isModifierSeparator && !StringUtil.isEmpty((String)element)) {
                    prefix = (String)prefix + separator + element;
                }
                String string = (String)prefix + separator + (String)cleanStringAndDepth.first;
                if (string == null) {
                    BemEmmetFilter.$$$reportNull$$$0(19);
                }
                return string;
            }
        }
        String string = className;
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Pair<String, Integer> getCleanStringAndDepth(@NotNull String name, @NotNull String separator) {
        if (name == null) {
            BemEmmetFilter.$$$reportNull$$$0(21);
        }
        if (separator == null) {
            BemEmmetFilter.$$$reportNull$$$0(22);
        }
        int result = 0;
        while (!separator.isEmpty() && name.startsWith(separator)) {
            ++result;
            name = name.substring(separator.length());
        }
        Pair pair = Pair.create((Object)name, (Object)result);
        if (pair == null) {
            BemEmmetFilter.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    private static String suggestBlockName(Iterable<String> classNames) {
        String result = (String)ContainerUtil.find(classNames, className -> BLOCK_NAME_PATTERN.matcher((CharSequence)className).matches());
        if (result == null) {
            result = (String)ContainerUtil.find(classNames, s -> s != null && !s.isEmpty() && Character.isLetter(s.charAt(0)));
        }
        String string = StringUtil.notNullize((String)result);
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String normalizeClassName(@NotNull String className, @NotNull String elementSeparator, @NotNull String shortElementPrefix) {
        if (className == null) {
            BemEmmetFilter.$$$reportNull$$$0(25);
        }
        if (elementSeparator == null) {
            BemEmmetFilter.$$$reportNull$$$0(26);
        }
        if (shortElementPrefix == null) {
            BemEmmetFilter.$$$reportNull$$$0(27);
        }
        if (shortElementPrefix.isEmpty() || !className.startsWith(shortElementPrefix)) {
            String string = className;
            if (string == null) {
                BemEmmetFilter.$$$reportNull$$$0(28);
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        while (className.startsWith(shortElementPrefix)) {
            className = className.substring(shortElementPrefix.length());
            result.append(elementSeparator);
        }
        String string = result.append(className).toString();
        if (string == null) {
            BemEmmetFilter.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 21, 22, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementSeparator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierSeparator";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortElementPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/filters/BemEmmetFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBemStateFromClassName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "transformClassNameToBemFormat";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCleanStringAndDepth";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestBlockName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeClassName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterNode";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processClassName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractBemStateFromClassName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillWithBemElements";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillWithBemModifiers";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "transformClassNameToBemFormat";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCleanStringAndDepth";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "normalizeClassName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 21, 22, 25, 26, 27 -> new IllegalArgumentException(string);
        };
    }

    private static final class BemState {
        @Nullable
        private String block;
        @Nullable
        private String element;
        @Nullable
        private String modifier;

        private BemState() {
        }

        private BemState(@Nullable String block, @Nullable String element, @Nullable String modifier) {
            this.block = block;
            this.element = element;
            this.modifier = modifier;
        }

        public void setModifier(@Nullable String modifier) {
            this.modifier = modifier;
        }

        public void setElement(@Nullable String element) {
            this.element = element;
        }

        public void setBlock(@Nullable String block) {
            this.block = block;
        }

        @Nullable
        public String getBlock() {
            return this.block;
        }

        @Nullable
        public String getElement() {
            return this.element;
        }

        @Nullable
        public String getModifier() {
            return this.modifier;
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty((String)this.block) && StringUtil.isEmpty((String)this.element) && StringUtil.isEmpty((String)this.modifier);
        }

        @NotNull
        public BemState copy() {
            return new BemState(this.block, this.element, this.modifier);
        }
    }
}

