/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.qoc;

import com.ibm.db2.cmx.runtime.statement.JavaType;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class TypeMapper {
    public static int mapSqlType(Class clazz) {
        if (clazz == String.class) {
            return 12;
        }
        if (clazz.getName().equals("int") || clazz.equals(Integer.class)) {
            return 4;
        }
        if (clazz.getName().equals("boolean") || clazz.equals(Boolean.class)) {
            return -7;
        }
        if (clazz.getName().equals("byte") || clazz.equals(Byte.class)) {
            return -6;
        }
        if (clazz.getName().equals("short") || clazz.equals(Short.class)) {
            return 5;
        }
        if (clazz.getName().equals("long") || clazz.equals(Long.class)) {
            return -5;
        }
        if (clazz.getName().equals("float") || clazz.equals(Float.class)) {
            return 6;
        }
        if (clazz.getName().equals("double") || clazz.equals(Double.class)) {
            return 8;
        }
        if (clazz.equals(BigDecimal.class)) {
            return 2;
        }
        if (clazz.equals(byte[].class)) {
            return -3;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 91;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 92;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return 2005;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return 2004;
        }
        if (Array.class.isAssignableFrom(clazz)) {
            return 2003;
        }
        if (Struct.class.isAssignableFrom(clazz)) {
            return 2002;
        }
        if (Ref.class.isAssignableFrom(clazz)) {
            return 2006;
        }
        return 2000;
    }

    public static String mapJavaToSqlTypeName(JavaType javaType) {
        switch (javaType) {
            case STRING: {
                return "VARCHAR";
            }
            case BIGDECIMAL: {
                return "NUMERIC";
            }
            case SIMPLE_BOOLEAN: 
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case SIMPLE_BYTE: 
            case BYTE: {
                return "TINYINT";
            }
            case SIMPLE_SHORT: 
            case SHORT: {
                return "SMALLINT";
            }
            case SIMPLE_INTEGER: 
            case INTEGER: {
                return "INTEGER";
            }
            case SIMPLE_LONG: 
            case LONG: {
                return "BIGINT";
            }
            case SIMPLE_FLOAT: 
            case FLOAT: {
                return "FLOAT";
            }
            case SIMPLE_DOUBLE: 
            case DOUBLE: {
                return "DOUBLE";
            }
            case BYTE_ARRAY: {
                return "VARBINARY";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case CLOB: {
                return "CLOB";
            }
            case BLOB: {
                return "BLOB";
            }
        }
        return "OTHER";
    }

    public static int mapJavaToSqlType(JavaType javaType) {
        switch (javaType) {
            case STRING: {
                return 12;
            }
            case BIGDECIMAL: {
                return 2;
            }
            case SIMPLE_BOOLEAN: 
            case BOOLEAN: {
                return 16;
            }
            case SIMPLE_BYTE: 
            case BYTE: {
                return -6;
            }
            case SIMPLE_SHORT: 
            case SHORT: {
                return 5;
            }
            case SIMPLE_INTEGER: 
            case INTEGER: {
                return 4;
            }
            case SIMPLE_LONG: 
            case LONG: {
                return -5;
            }
            case SIMPLE_FLOAT: 
            case FLOAT: {
                return 6;
            }
            case SIMPLE_DOUBLE: 
            case DOUBLE: {
                return 8;
            }
            case BYTE_ARRAY: {
                return -3;
            }
            case DATE: {
                return 91;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
            case CLOB: {
                return 2005;
            }
            case BLOB: {
                return 2004;
            }
        }
        return 1111;
    }

    public static String mapSqlTypeToJavaClassName(int n2) {
        switch (n2) {
            case 12: {
                return "java.lang.String";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 1: {
                return "java.lang.String";
            }
            case 5: {
                return "java.lang.Short";
            }
            case -6: {
                return "java.lang.Byte";
            }
            case -5: {
                return "java.lang.Long";
            }
            case -2: {
                return byte[].class.getName();
            }
            case -7: {
                return "java.lang.Boolean";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 3: {
                return "java.math.BigDecimal";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 6: {
                return "java.lang.Float";
            }
            case -4: {
                return byte[].class.getName();
            }
            case -1: {
                return "java.lang.String";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case -3: {
                return byte[].class.getName();
            }
        }
        return "java.lang.Object";
    }
}

