/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.BoolOpTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.TypeParamTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.runtime.formatting.ComplexFormatter;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;

public class Unparser
implements SSTreeVisitor<Void> {
    private TruffleStringBuilder builder;
    private int level;
    private static final int PR_TUPLE = 0;
    private static final int PR_TEST = 1;
    private static final int PR_OR = 2;
    private static final int PR_AND = 3;
    private static final int PR_NOT = 4;
    private static final int PR_CMP = 5;
    private static final int PR_EXPR = 6;
    private static final int PR_BOR = 6;
    private static final int PR_BXOR = 7;
    private static final int PR_BAND = 8;
    private static final int PR_SHIFT = 9;
    private static final int PR_ARITH = 10;
    private static final int PR_TERM = 11;
    private static final int PR_FACTOR = 12;
    private static final int PR_POWER = 13;
    private static final int PR_AWAIT = 14;
    private static final int PR_ATOM = 15;
    private static final TruffleString OPEN_BR = PythonUtils.tsLiteral("{");
    private static final TruffleString DBL_OPEN_BR = PythonUtils.tsLiteral("{{");
    private static final TruffleString CLOSE_BR = PythonUtils.tsLiteral("}");
    private static final TruffleString DBL_CLOSE_BR = PythonUtils.tsLiteral("}}");

    public static TruffleString unparse(SSTNode node) {
        return Unparser.unparse(node, 1);
    }

    private static TruffleString unparse(SSTNode node, int level) {
        TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        node.accept(new Unparser(builder, level));
        return builder.toStringUncached();
    }

    private Unparser(TruffleStringBuilder builder, int level) {
        this.builder = builder;
        this.level = level;
    }

    private void appendStr(TruffleString temp_fv_str) {
        this.builder.appendStringUncached(temp_fv_str);
    }

    private void appendStr(String s) {
        this.appendStr(TruffleString.fromJavaStringUncached((String)s, (TruffleString.Encoding)PythonUtils.TS_ENCODING));
    }

    private void appendStrIf(boolean cond, String s) {
        if (cond) {
            this.appendStr(s);
        }
    }

    private void appendExpr(SSTNode node, int newLevel) {
        int savedLevel = this.level;
        this.level = newLevel;
        node.accept(this);
        this.level = savedLevel;
    }

    int len(SSTNode[] a) {
        return a != null ? a.length : 0;
    }

    private static TruffleString escapeBraces(TruffleString s) {
        StringNodes.StringReplaceNode replace = StringNodes.StringReplaceNode.getUncached();
        TruffleString t = replace.execute(s, OPEN_BR, DBL_OPEN_BR, -1);
        return replace.execute(t, CLOSE_BR, DBL_CLOSE_BR, -1);
    }

    private void appendFString(TruffleString string) {
        this.appendStr(Unparser.escapeBraces(string));
    }

    private void appendFStringElement(ExprTy e, boolean isFormatSpec) {
        if (e instanceof ExprTy.Constant) {
            ExprTy.Constant c = (ExprTy.Constant)e;
            this.appendFString(PythonUtils.codePointsToTruffleString(c.value.getCodePoints()));
        } else if (e instanceof ExprTy.JoinedStr) {
            this.appendJoinedStr((ExprTy.JoinedStr)e, isFormatSpec);
        } else if (e instanceof ExprTy.FormattedValue) {
            this.visit((ExprTy.FormattedValue)e);
        } else {
            throw new IllegalStateException("unknown expression kind inside f-string");
        }
    }

    public TruffleString buildFStringBody(ExprTy[] values, boolean isFormatSpec) {
        TruffleStringBuilder savedBuilder = this.builder;
        this.builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        for (int i = 0; i < values.length; ++i) {
            this.appendFStringElement(values[i], isFormatSpec);
        }
        TruffleString result = this.builder.toStringUncached();
        this.builder = savedBuilder;
        return result;
    }

    private void appendJoinedStr(ExprTy.JoinedStr node, boolean isFormatSpec) {
        TruffleString body = this.buildFStringBody(node.values, isFormatSpec);
        if (!isFormatSpec) {
            this.appendStr("f");
            this.appendStr(StringNodes.StringReprNode.getUncached().execute(body));
        } else {
            this.appendStr(body);
        }
    }

    @Override
    public Void visit(AliasTy node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(ArgTy node) {
        this.appendStr(node.arg);
        if (node.annotation != null) {
            this.appendStr(": ");
            this.appendExpr(node.annotation, 1);
        }
        return null;
    }

    @Override
    public Void visit(ArgumentsTy args) {
        int di;
        int i;
        boolean first = true;
        int posonlyargCount = this.len(args.posOnlyArgs);
        int argCount = this.len(args.args);
        int defaultCount = this.len(args.defaults);
        for (i = 0; i < posonlyargCount + argCount; ++i) {
            if (first) {
                first = false;
            } else {
                this.appendStr(", ");
            }
            if (i < posonlyargCount) {
                this.visit(args.posOnlyArgs[i]);
            } else {
                this.visit(args.args[i - posonlyargCount]);
            }
            di = i - posonlyargCount - argCount + defaultCount;
            if (di >= 0) {
                this.appendStr("=");
                this.appendExpr(args.defaults[di], 1);
            }
            if (posonlyargCount <= 0 || i + 1 != posonlyargCount) continue;
            this.appendStr(", /");
        }
        if (args.varArg != null || this.len(args.kwOnlyArgs) > 0) {
            if (first) {
                first = false;
            } else {
                this.appendStr(", ");
            }
            this.appendStr("*");
            if (args.varArg != null) {
                this.visit(args.varArg);
            }
        }
        argCount = this.len(args.kwOnlyArgs);
        defaultCount = this.len(args.kwDefaults);
        for (i = 0; i < argCount; ++i) {
            ExprTy kwDefault;
            if (first) {
                first = false;
            } else {
                this.appendStr(", ");
            }
            this.visit(args.kwOnlyArgs[i]);
            di = i - argCount + defaultCount;
            if (di < 0 || (kwDefault = args.kwDefaults[di]) == null) continue;
            this.appendStr("=");
            this.appendExpr(kwDefault, 1);
        }
        if (args.kwArg != null) {
            if (!first) {
                this.appendStr(", ");
            }
            this.appendStr("**");
            this.visit(args.kwArg);
        }
        return null;
    }

    @Override
    public Void visit(ComprehensionTy node) {
        this.appendStr(node.isAsync ? " async for " : " for ");
        this.appendExpr(node.target, 0);
        this.appendStr(" in ");
        this.appendExpr(node.iter, 2);
        int ifCount = this.len(node.ifs);
        for (int i = 0; i < ifCount; ++i) {
            this.appendStr(" if ");
            this.appendExpr(node.ifs[i], 2);
        }
        return null;
    }

    private void appendComprehensions(ComprehensionTy[] comprehensions) {
        for (int i = 0; i < comprehensions.length; ++i) {
            this.visit(comprehensions[i]);
        }
    }

    @Override
    public Void visit(ExprTy.Attribute node) {
        ExprTy v = node.value;
        this.appendExpr(v, 15);
        String period = v instanceof ExprTy.Constant && (((ExprTy.Constant)v).value.kind == ConstantValue.Kind.LONG || ((ExprTy.Constant)v).value.kind == ConstantValue.Kind.BIGINTEGER) ? " ." : ".";
        this.appendStr(period);
        this.appendStr(node.attr);
        return null;
    }

    @Override
    public Void visit(ExprTy.Await node) {
        this.appendStrIf(this.level > 14, "(");
        this.appendStr("await ");
        this.appendExpr(node.value, 15);
        this.appendStrIf(this.level > 14, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.BinOp node) {
        int pr;
        String op;
        boolean rassoc = false;
        switch (node.op) {
            case Add: {
                op = " + ";
                pr = 10;
                break;
            }
            case Sub: {
                op = " - ";
                pr = 10;
                break;
            }
            case Mult: {
                op = " * ";
                pr = 11;
                break;
            }
            case MatMult: {
                op = " @ ";
                pr = 11;
                break;
            }
            case Div: {
                op = " / ";
                pr = 11;
                break;
            }
            case Mod: {
                op = " % ";
                pr = 11;
                break;
            }
            case LShift: {
                op = " << ";
                pr = 9;
                break;
            }
            case RShift: {
                op = " >> ";
                pr = 9;
                break;
            }
            case BitOr: {
                op = " | ";
                pr = 6;
                break;
            }
            case BitXor: {
                op = " ^ ";
                pr = 7;
                break;
            }
            case BitAnd: {
                op = " & ";
                pr = 8;
                break;
            }
            case FloorDiv: {
                op = " // ";
                pr = 11;
                break;
            }
            case Pow: {
                op = " ** ";
                pr = 13;
                rassoc = true;
                break;
            }
            default: {
                throw new IllegalStateException("unknown binary operator");
            }
        }
        this.appendStrIf(this.level > pr, "(");
        this.appendExpr(node.left, pr + (rassoc ? 1 : 0));
        this.appendStr(op);
        this.appendExpr(node.right, pr + (rassoc ? 0 : 1));
        this.appendStrIf(this.level > pr, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.BoolOp node) {
        String op = node.op == BoolOpTy.And ? " and " : " or ";
        int pr = node.op == BoolOpTy.And ? 3 : 2;
        this.appendStrIf(this.level > pr, "(");
        for (int i = 0; i < node.values.length; ++i) {
            this.appendStrIf(i > 0, op);
            this.appendExpr(node.values[i], pr + 1);
        }
        this.appendStrIf(this.level > pr, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Call node) {
        int i;
        ExprTy expr;
        this.appendExpr(node.func, 15);
        int argCount = this.len(node.args);
        int kwCount = this.len(node.keywords);
        if (argCount == 1 && kwCount == 0 && (expr = node.args[0]) instanceof ExprTy.GeneratorExp) {
            return this.visit((ExprTy.GeneratorExp)expr);
        }
        this.appendStr("(");
        boolean first = true;
        for (i = 0; i < argCount; ++i) {
            if (first) {
                first = false;
            } else {
                this.appendStr(", ");
            }
            this.appendExpr(node.args[i], 1);
        }
        for (i = 0; i < kwCount; ++i) {
            if (first) {
                first = false;
            } else {
                this.appendStr(", ");
            }
            this.visit(node.keywords[i]);
        }
        this.appendStr(")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Compare node) {
        this.appendStrIf(this.level > 5, "(");
        int comparatorCount = this.len(node.comparators);
        assert (comparatorCount > 0);
        assert (comparatorCount == node.ops.length);
        this.appendExpr(node.left, 6);
        for (int i = 0; i < comparatorCount; ++i) {
            this.appendStr(switch (node.ops[i]) {
                case CmpOpTy.Eq -> " == ";
                case CmpOpTy.NotEq -> " != ";
                case CmpOpTy.Lt -> " < ";
                case CmpOpTy.LtE -> " <= ";
                case CmpOpTy.Gt -> " > ";
                case CmpOpTy.GtE -> " >= ";
                case CmpOpTy.Is -> " is ";
                case CmpOpTy.IsNot -> " is not ";
                case CmpOpTy.In -> " in ";
                case CmpOpTy.NotIn -> " not in ";
                default -> throw new IllegalStateException("unexpected comparison kind");
            });
            this.appendExpr(node.comparators[i], 6);
        }
        this.appendStrIf(this.level > 5, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Constant node) {
        if (node.value.kind == ConstantValue.Kind.ELLIPSIS) {
            this.appendStr("...");
            return null;
        }
        if (node.kind instanceof String) {
            this.appendStr((String)node.kind);
        } else if (node.kind instanceof byte[]) {
            this.appendStr(new String((byte[])node.kind));
        }
        this.appendConstantValue(node.value);
        return null;
    }

    private void appendConstantValue(ConstantValue value) {
        switch (value.kind) {
            case LONG: {
                this.builder.appendLongNumberUncached(value.getLong());
                break;
            }
            case DOUBLE: {
                FloatFormatter f = new FloatFormatter(FloatBuiltins.StrNode.spec, null);
                f.setMinFracDigits(1);
                TruffleString result = f.format(value.getDouble()).getResult();
                this.appendStr(result);
                break;
            }
            case BOOLEAN: {
                this.appendStr(value.getBoolean() ? "True" : "False");
                break;
            }
            case CODEPOINTS: {
                this.appendStr(StringNodes.StringReprNode.getUncached().execute(PythonUtils.codePointsToTruffleString(value.getCodePoints())));
                break;
            }
            case BIGINTEGER: {
                this.appendStr(value.getBigInteger().toString());
                break;
            }
            case NONE: {
                this.appendStr("None");
                break;
            }
            case BYTES: {
                byte[] bytes = value.getBytes();
                BytesUtils.reprLoop(this.builder, bytes, bytes.length, TruffleStringBuilder.AppendCodePointNode.getUncached());
                break;
            }
            case COMPLEX: {
                double[] num = value.getComplex();
                ComplexFormatter formatter = new ComplexFormatter(new InternalFormat.Spec(-1, '\uffff'), null);
                formatter.format(num[0], num[1]);
                this.appendStr(formatter.pad().getResult());
                break;
            }
            case ELLIPSIS: {
                this.appendStr("Ellipsis");
                break;
            }
            case TUPLE: {
                this.appendTuple(value.getTupleElements());
                break;
            }
            case FROZENSET: {
                this.appendFrozenset(value.getFrozensetElements());
                break;
            }
            default: {
                throw new IllegalStateException("unknown constant kind");
            }
        }
    }

    private void appendTuple(ConstantValue[] values) {
        this.appendStr("(");
        for (int i = 0; i < values.length; ++i) {
            this.appendStrIf(i > 0, ", ");
            this.appendConstantValue(values[i]);
        }
        this.appendStrIf(values.length == 1, ",");
        this.appendStr(")");
    }

    private void appendFrozenset(ConstantValue[] values) {
        this.appendStr("frozenset(");
        if (values.length > 0) {
            this.appendStr("{");
            for (int i = 0; i < values.length; ++i) {
                this.appendStrIf(i > 0, ", ");
                this.appendConstantValue(values[i]);
            }
            this.appendStr("}");
        }
        this.appendStr(")");
    }

    @Override
    public Void visit(ExprTy.Dict node) {
        this.appendStr("{");
        for (int i = 0; i < this.len(node.values); ++i) {
            this.appendStrIf(i > 0, ", ");
            ExprTy key_node = node.keys[i];
            if (key_node != null) {
                this.appendExpr(key_node, 1);
                this.appendStr(": ");
                this.appendExpr(node.values[i], 1);
                continue;
            }
            this.appendStr("**");
            this.appendExpr(node.values[i], 6);
        }
        this.appendStr("}");
        return null;
    }

    @Override
    public Void visit(ExprTy.DictComp node) {
        this.appendStr("{");
        this.appendExpr(node.key, 1);
        this.appendStr(": ");
        this.appendExpr(node.value, 1);
        this.appendComprehensions(node.generators);
        this.appendStr("}");
        return null;
    }

    @Override
    public Void visit(ExprTy.FormattedValue node) {
        String outerBrace = "{";
        TruffleString tempFvStr = Unparser.unparse(node.value, 2);
        if (tempFvStr.codePointAtByteIndexUncached(0, PythonUtils.TS_ENCODING) == 123) {
            outerBrace = "{ ";
        }
        this.appendStr(outerBrace);
        this.appendStr(tempFvStr);
        if (node.conversion > 0) {
            this.appendStr(switch (node.conversion) {
                case 97 -> "!a";
                case 114 -> "!r";
                case 115 -> "!s";
                default -> throw PRaiseNode.raiseStatic(null, PythonBuiltinClassType.SystemError, ErrorMessages.UNKNOWN_F_VALUE_CONVERSION_KIND);
            });
        }
        if (node.formatSpec != null) {
            this.appendStr(":");
            this.appendFStringElement(node.formatSpec, true);
        }
        this.appendStr("}");
        return null;
    }

    @Override
    public Void visit(ExprTy.GeneratorExp node) {
        this.appendStr("(");
        this.appendExpr(node.element, 1);
        this.appendComprehensions(node.generators);
        this.appendStr(")");
        return null;
    }

    @Override
    public Void visit(ExprTy.IfExp node) {
        this.appendStrIf(this.level > 1, "(");
        this.appendExpr(node.body, 2);
        this.appendStr(" if ");
        this.appendExpr(node.test, 2);
        this.appendStr(" else ");
        this.appendExpr(node.orElse, 1);
        this.appendStrIf(this.level > 1, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.JoinedStr node) {
        this.appendJoinedStr(node, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.Lambda node) {
        this.appendStrIf(this.level > 1, "(");
        int nPositional = this.len(node.args.args) + this.len(node.args.posOnlyArgs);
        this.appendStr(nPositional > 0 ? "lambda " : "lambda");
        this.visit(node.args);
        this.appendStr(": ");
        this.appendExpr(node.body, 1);
        this.appendStrIf(this.level > 1, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.List node) {
        this.appendStr("[");
        for (int i = 0; i < this.len(node.elements); ++i) {
            this.appendStrIf(i > 0, ", ");
            this.appendExpr(node.elements[i], 1);
        }
        this.appendStr("]");
        return null;
    }

    @Override
    public Void visit(ExprTy.ListComp node) {
        this.appendStr("(");
        this.appendExpr(node.element, 1);
        this.appendComprehensions(node.generators);
        this.appendStr(")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Name node) {
        this.appendStr(node.id);
        return null;
    }

    @Override
    public Void visit(ExprTy.NamedExpr node) {
        this.appendStrIf(this.level > 0, "(");
        this.appendExpr(node.target, 15);
        this.appendStr(" := ");
        this.appendExpr(node.value, 15);
        this.appendStrIf(this.level > 0, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Set node) {
        this.appendStr("{");
        for (int i = 0; i < this.len(node.elements); ++i) {
            this.appendStrIf(i > 0, ", ");
            this.appendExpr(node.elements[i], 1);
        }
        this.appendStr("}");
        return null;
    }

    @Override
    public Void visit(ExprTy.SetComp node) {
        this.appendStr("(");
        this.appendExpr(node.element, 1);
        this.appendComprehensions(node.generators);
        this.appendStr(")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Slice node) {
        if (node.lower != null) {
            this.appendExpr(node.lower, 1);
        }
        this.appendStr(":");
        if (node.upper != null) {
            this.appendExpr(node.upper, 1);
        }
        if (node.step != null) {
            this.appendStr(":");
            this.appendExpr(node.step, 1);
        }
        return null;
    }

    @Override
    public Void visit(ExprTy.Starred node) {
        this.appendStr("*");
        this.appendExpr(node.value, 6);
        return null;
    }

    @Override
    public Void visit(ExprTy.Subscript node) {
        this.appendExpr(node.value, 15);
        this.appendStr("[");
        this.appendExpr(node.slice, 0);
        this.appendStr("]");
        return null;
    }

    @Override
    public Void visit(ExprTy.Tuple node) {
        int elemCount = this.len(node.elements);
        if (elemCount == 0) {
            this.appendStr("()");
            return null;
        }
        this.appendStrIf(this.level > 0, "(");
        for (int i = 0; i < elemCount; ++i) {
            this.appendStrIf(i > 0, ", ");
            this.appendExpr(node.elements[i], 1);
        }
        this.appendStrIf(elemCount == 1, ",");
        this.appendStrIf(this.level > 0, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.UnaryOp node) {
        String op;
        int pr = switch (node.op) {
            case UnaryOpTy.Invert -> {
                op = "~";
                yield 12;
            }
            case UnaryOpTy.Not -> {
                op = "not ";
                yield 4;
            }
            case UnaryOpTy.UAdd -> {
                op = "+";
                yield 12;
            }
            case UnaryOpTy.USub -> {
                op = "-";
                yield 12;
            }
            default -> throw new IllegalStateException("unknown unary operator");
        };
        this.appendStrIf(this.level > pr, "(");
        this.appendStr(op);
        this.appendExpr(node.operand, pr);
        this.appendStrIf(this.level > pr, ")");
        return null;
    }

    @Override
    public Void visit(ExprTy.Yield node) {
        if (node.value == null) {
            this.appendStr("(yield)");
            return null;
        }
        this.appendStr("(yield ");
        this.appendExpr(node.value, 1);
        this.appendStr(")");
        return null;
    }

    @Override
    public Void visit(ExprTy.YieldFrom node) {
        this.appendStr("(yield from ");
        this.appendExpr(node.value, 1);
        this.appendStr(")");
        return null;
    }

    @Override
    public Void visit(KeywordTy node) {
        if (node.arg == null) {
            this.appendStr("**");
        } else {
            this.appendStr(node.arg);
            this.appendStr("=");
        }
        this.appendExpr(node.value, 1);
        return null;
    }

    @Override
    public Void visit(ModTy.Expression node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(ModTy.FunctionType node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(ModTy.Interactive node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(ModTy.Module node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(TypeIgnoreTy.TypeIgnore node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.AnnAssign node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Assert node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Assign node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.AsyncFor node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.AsyncFunctionDef node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.AsyncWith node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.AugAssign node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.ClassDef node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Delete node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Expr node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.For node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.FunctionDef node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Global node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.If node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Import node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.ImportFrom node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Match node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(MatchCaseTy node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchAs node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchClass node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchMapping node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchOr node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchSequence node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchSingleton node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchStar node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(PatternTy.MatchValue node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Nonlocal node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Raise node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Return node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Try node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.TryStar node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(ExceptHandlerTy.ExceptHandler node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.While node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.With node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(WithItemTy node) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Break aThis) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Continue aThis) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.Pass aThis) {
        throw new IllegalStateException("unknown expression kind");
    }

    @Override
    public Void visit(StmtTy.TypeAlias node) {
        throw new IllegalStateException("unknown AST node");
    }

    @Override
    public Void visit(TypeParamTy.TypeVar node) {
        throw new IllegalStateException("unknown AST node");
    }

    @Override
    public Void visit(TypeParamTy.ParamSpec node) {
        throw new IllegalStateException("unknown AST node");
    }

    @Override
    public Void visit(TypeParamTy.TypeVarTuple node) {
        throw new IllegalStateException("unknown AST node");
    }
}

