/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.GoldenKey;
import com.shatteredpixel.shatteredpixeldungeon.items.trinkets.TrinketCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.Builder;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.GridBuilder;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.RegionDecoLineRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.SegmentedRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.entrance.EntranceRoom;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class VaultLevel
extends CityLevel {
    @Override
    protected ArrayList<Room> initRooms() {
        ArrayList<Room> initRooms = new ArrayList<Room>();
        this.roomEntrance = new VaultEntrance();
        initRooms.add(this.roomEntrance);
        for (int i = 0; i < 23; ++i) {
            initRooms.add(new VaultSegmentedRoom());
        }
        initRooms.add(new VaultRegionDecoLineRoom());
        return initRooms;
    }

    @Override
    protected Builder builder() {
        return new GridBuilder();
    }

    @Override
    protected int nTraps() {
        return 0;
    }

    @Override
    protected boolean build() {
        for (int i = 0; i < 20; ++i) {
            Item item = Generator.randomUsingDefaults(Random.oneOf(Generator.Category.WEAPON, Generator.Category.WEAPON, Generator.Category.WEAPON, Generator.Category.ARMOR, Generator.Category.WAND, Generator.Category.RING));
            if (item.cursed) {
                item.cursed = false;
                if (item instanceof MeleeWeapon && ((MeleeWeapon)item).hasCurseEnchant()) {
                    ((MeleeWeapon)item).enchant(null);
                } else if (item instanceof Armor && ((Armor)item).hasCurseGlyph()) {
                    ((Armor)item).inscribe(null);
                }
            }
            item.cursedKnown = true;
            item.levelKnown = true;
            this.addItemToSpawn(item);
        }
        if (!super.build()) {
            return false;
        }
        Room finalRoom = this.room(RegionDecoLineRoom.class);
        for (Point p : finalRoom.getPoints()) {
            int cell = this.pointToCell(p);
            if (this.map[cell] == 33) {
                VaultLevel.set(cell, 34, this);
                continue;
            }
            if (this.map[cell] != 1 && this.map[cell] != 20 && this.map[cell] != 29 && this.map[cell] != 15 && this.map[cell] != 2) continue;
            VaultLevel.set(cell, 14, this);
        }
        VaultLevel.set(this.entrance(), 1, this);
        this.transitions.add(new LevelTransition(this, this.entrance(), LevelTransition.Type.BRANCH_ENTRANCE, Dungeon.depth, 0, LevelTransition.Type.BRANCH_EXIT));
        return true;
    }

    @Override
    public boolean activateTransition(Hero hero, LevelTransition transition) {
        return false;
    }

    @Override
    public Mob createMob() {
        return null;
    }

    @Override
    protected void createMobs() {
    }

    @Override
    public Actor addRespawner() {
        return null;
    }

    @Override
    protected void createItems() {
        for (Item item : this.itemsToSpawn) {
            int cell = this.randomDropCell();
            if (item instanceof TrinketCatalyst) {
                this.drop((Item)item, (int)cell).type = Heap.Type.LOCKED_CHEST;
                int keyCell = this.randomDropCell();
                this.drop((Item)new GoldenKey((int)Dungeon.depth), (int)keyCell).type = Heap.Type.HEAP;
                if (this.map[keyCell] == 15 || this.map[keyCell] == 30) {
                    this.map[keyCell] = 2;
                    this.losBlocking[keyCell] = false;
                }
            } else {
                this.drop((Item)item, (int)cell).type = Heap.Type.HEAP;
            }
            if (this.map[cell] != 15 && this.map[cell] != 30) continue;
            this.map[cell] = 2;
            this.losBlocking[cell] = false;
        }
    }

    @Override
    public int randomRespawnCell(Char ch) {
        return this.entrance() - this.width();
    }

    public static class VaultEntrance
    extends EntranceRoom {
        @Override
        public int maxConnections(int direction) {
            if (direction == 1 || direction == 2) {
                return 0;
            }
            return super.maxConnections(direction);
        }

        @Override
        public boolean canMerge(Level l, Room other, Point p, int mergeTerrain) {
            return false;
        }
    }

    public static class VaultSegmentedRoom
    extends SegmentedRoom {
        @Override
        public float[] sizeCatProbs() {
            return new float[]{1.0f, 0.0f, 0.0f};
        }
    }

    public static class VaultRegionDecoLineRoom
    extends RegionDecoLineRoom {
        @Override
        public float[] sizeCatProbs() {
            return new float[]{0.0f, 0.0f, 1.0f};
        }

        @Override
        public boolean isExit() {
            return true;
        }

        @Override
        public int maxConnections(int direction) {
            return 1;
        }

        @Override
        public boolean canPlaceItem(Point p, Level l) {
            return false;
        }

        @Override
        public boolean canMerge(Level l, Room other, Point p, int mergeTerrain) {
            return false;
        }
    }
}

