﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/socialmessaging/SocialMessagingRequest.h>
#include <aws/socialmessaging/SocialMessaging_EXPORTS.h>
#include <aws/socialmessaging/model/WhatsAppBusinessAccountEventDestination.h>

#include <utility>

namespace Aws {
namespace SocialMessaging {
namespace Model {

/**
 */
class PutWhatsAppBusinessAccountEventDestinationsRequest : public SocialMessagingRequest {
 public:
  AWS_SOCIALMESSAGING_API PutWhatsAppBusinessAccountEventDestinationsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutWhatsAppBusinessAccountEventDestinations"; }

  AWS_SOCIALMESSAGING_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of your WhatsApp Business Account. WABA identifiers are
   * formatted as <code>waba-01234567890123456789012345678901</code>. Use <a
   * href="https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_ListLinkedWhatsAppBusinessAccounts.html">ListLinkedWhatsAppBusinessAccounts</a>
   * to list all WABAs and their details.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  PutWhatsAppBusinessAccountEventDestinationsRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of <code>WhatsAppBusinessAccountEventDestination</code> event
   * destinations.</p>
   */
  inline const Aws::Vector<WhatsAppBusinessAccountEventDestination>& GetEventDestinations() const { return m_eventDestinations; }
  inline bool EventDestinationsHasBeenSet() const { return m_eventDestinationsHasBeenSet; }
  template <typename EventDestinationsT = Aws::Vector<WhatsAppBusinessAccountEventDestination>>
  void SetEventDestinations(EventDestinationsT&& value) {
    m_eventDestinationsHasBeenSet = true;
    m_eventDestinations = std::forward<EventDestinationsT>(value);
  }
  template <typename EventDestinationsT = Aws::Vector<WhatsAppBusinessAccountEventDestination>>
  PutWhatsAppBusinessAccountEventDestinationsRequest& WithEventDestinations(EventDestinationsT&& value) {
    SetEventDestinations(std::forward<EventDestinationsT>(value));
    return *this;
  }
  template <typename EventDestinationsT = WhatsAppBusinessAccountEventDestination>
  PutWhatsAppBusinessAccountEventDestinationsRequest& AddEventDestinations(EventDestinationsT&& value) {
    m_eventDestinationsHasBeenSet = true;
    m_eventDestinations.emplace_back(std::forward<EventDestinationsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::Vector<WhatsAppBusinessAccountEventDestination> m_eventDestinations;
  bool m_eventDestinationsHasBeenSet = false;
};

}  // namespace Model
}  // namespace SocialMessaging
}  // namespace Aws
