﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/qapps/QApps_EXPORTS.h>
#include <aws/qapps/model/AttributeFilter.h>
#include <aws/qapps/model/CardOutputSource.h>
#include <aws/qapps/model/CardType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QApps {
namespace Model {

/**
 * <p>A card in a Amazon Q App that generates a response based on the Amazon Q
 * Business service.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/QQueryCard">AWS
 * API Reference</a></p>
 */
class QQueryCard {
 public:
  AWS_QAPPS_API QQueryCard() = default;
  AWS_QAPPS_API QQueryCard(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API QQueryCard& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the query card. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  QQueryCard& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The title or label of the query card.</p>
   */
  inline const Aws::String& GetTitle() const { return m_title; }
  inline bool TitleHasBeenSet() const { return m_titleHasBeenSet; }
  template <typename TitleT = Aws::String>
  void SetTitle(TitleT&& value) {
    m_titleHasBeenSet = true;
    m_title = std::forward<TitleT>(value);
  }
  template <typename TitleT = Aws::String>
  QQueryCard& WithTitle(TitleT&& value) {
    SetTitle(std::forward<TitleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Any dependencies or requirements for the query card.</p>
   */
  inline const Aws::Vector<Aws::String>& GetDependencies() const { return m_dependencies; }
  inline bool DependenciesHasBeenSet() const { return m_dependenciesHasBeenSet; }
  template <typename DependenciesT = Aws::Vector<Aws::String>>
  void SetDependencies(DependenciesT&& value) {
    m_dependenciesHasBeenSet = true;
    m_dependencies = std::forward<DependenciesT>(value);
  }
  template <typename DependenciesT = Aws::Vector<Aws::String>>
  QQueryCard& WithDependencies(DependenciesT&& value) {
    SetDependencies(std::forward<DependenciesT>(value));
    return *this;
  }
  template <typename DependenciesT = Aws::String>
  QQueryCard& AddDependencies(DependenciesT&& value) {
    m_dependenciesHasBeenSet = true;
    m_dependencies.emplace_back(std::forward<DependenciesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the card.</p>
   */
  inline CardType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(CardType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline QQueryCard& WithType(CardType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The prompt or instructions displayed for the query card.</p>
   */
  inline const Aws::String& GetPrompt() const { return m_prompt; }
  inline bool PromptHasBeenSet() const { return m_promptHasBeenSet; }
  template <typename PromptT = Aws::String>
  void SetPrompt(PromptT&& value) {
    m_promptHasBeenSet = true;
    m_prompt = std::forward<PromptT>(value);
  }
  template <typename PromptT = Aws::String>
  QQueryCard& WithPrompt(PromptT&& value) {
    SetPrompt(std::forward<PromptT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source or type of output generated by the query card.</p>
   */
  inline CardOutputSource GetOutputSource() const { return m_outputSource; }
  inline bool OutputSourceHasBeenSet() const { return m_outputSourceHasBeenSet; }
  inline void SetOutputSource(CardOutputSource value) {
    m_outputSourceHasBeenSet = true;
    m_outputSource = value;
  }
  inline QQueryCard& WithOutputSource(CardOutputSource value) {
    SetOutputSource(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Q Business filters applied in this query card when resolving data
   * sources</p>
   */
  inline const AttributeFilter& GetAttributeFilter() const { return m_attributeFilter; }
  inline bool AttributeFilterHasBeenSet() const { return m_attributeFilterHasBeenSet; }
  template <typename AttributeFilterT = AttributeFilter>
  void SetAttributeFilter(AttributeFilterT&& value) {
    m_attributeFilterHasBeenSet = true;
    m_attributeFilter = std::forward<AttributeFilterT>(value);
  }
  template <typename AttributeFilterT = AttributeFilter>
  QQueryCard& WithAttributeFilter(AttributeFilterT&& value) {
    SetAttributeFilter(std::forward<AttributeFilterT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Any dependencies for the query card, where the dependencies are references to
   * the collected responses.</p>
   */
  inline const Aws::Vector<Aws::String>& GetMemoryReferences() const { return m_memoryReferences; }
  inline bool MemoryReferencesHasBeenSet() const { return m_memoryReferencesHasBeenSet; }
  template <typename MemoryReferencesT = Aws::Vector<Aws::String>>
  void SetMemoryReferences(MemoryReferencesT&& value) {
    m_memoryReferencesHasBeenSet = true;
    m_memoryReferences = std::forward<MemoryReferencesT>(value);
  }
  template <typename MemoryReferencesT = Aws::Vector<Aws::String>>
  QQueryCard& WithMemoryReferences(MemoryReferencesT&& value) {
    SetMemoryReferences(std::forward<MemoryReferencesT>(value));
    return *this;
  }
  template <typename MemoryReferencesT = Aws::String>
  QQueryCard& AddMemoryReferences(MemoryReferencesT&& value) {
    m_memoryReferencesHasBeenSet = true;
    m_memoryReferences.emplace_back(std::forward<MemoryReferencesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_title;

  Aws::Vector<Aws::String> m_dependencies;

  CardType m_type{CardType::NOT_SET};

  Aws::String m_prompt;

  CardOutputSource m_outputSource{CardOutputSource::NOT_SET};

  AttributeFilter m_attributeFilter;

  Aws::Vector<Aws::String> m_memoryReferences;
  bool m_idHasBeenSet = false;
  bool m_titleHasBeenSet = false;
  bool m_dependenciesHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_promptHasBeenSet = false;
  bool m_outputSourceHasBeenSet = false;
  bool m_attributeFilterHasBeenSet = false;
  bool m_memoryReferencesHasBeenSet = false;
};

}  // namespace Model
}  // namespace QApps
}  // namespace Aws
