﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/panorama/Panorama_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Panorama {
namespace Model {

/**
 * <p>A package object.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/PackageObject">AWS
 * API Reference</a></p>
 */
class PackageObject {
 public:
  AWS_PANORAMA_API PackageObject() = default;
  AWS_PANORAMA_API PackageObject(Aws::Utils::Json::JsonView jsonValue);
  AWS_PANORAMA_API PackageObject& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PANORAMA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The object's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  PackageObject& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The object's package version.</p>
   */
  inline const Aws::String& GetPackageVersion() const { return m_packageVersion; }
  inline bool PackageVersionHasBeenSet() const { return m_packageVersionHasBeenSet; }
  template <typename PackageVersionT = Aws::String>
  void SetPackageVersion(PackageVersionT&& value) {
    m_packageVersionHasBeenSet = true;
    m_packageVersion = std::forward<PackageVersionT>(value);
  }
  template <typename PackageVersionT = Aws::String>
  PackageObject& WithPackageVersion(PackageVersionT&& value) {
    SetPackageVersion(std::forward<PackageVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The object's patch version.</p>
   */
  inline const Aws::String& GetPatchVersion() const { return m_patchVersion; }
  inline bool PatchVersionHasBeenSet() const { return m_patchVersionHasBeenSet; }
  template <typename PatchVersionT = Aws::String>
  void SetPatchVersion(PatchVersionT&& value) {
    m_patchVersionHasBeenSet = true;
    m_patchVersion = std::forward<PatchVersionT>(value);
  }
  template <typename PatchVersionT = Aws::String>
  PackageObject& WithPatchVersion(PatchVersionT&& value) {
    SetPatchVersion(std::forward<PatchVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_packageVersion;

  Aws::String m_patchVersion;
  bool m_nameHasBeenSet = false;
  bool m_packageVersionHasBeenSet = false;
  bool m_patchVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Panorama
}  // namespace Aws
