/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.svgicons.FixedSizeUIIcon;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.UIIcon;

public class DefaultConditionRenderer
implements ListCellRenderer,
TableCellRenderer {
    private final String noValueText;
    private final boolean renderNamedConditions;

    public DefaultConditionRenderer(String noValueText, boolean renderNamedConditions) {
        this.noValueText = noValueText;
        this.renderNamedConditions = renderNamedConditions;
    }

    public JComponent getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent cellRendererComponent = this.getCellRendererComponent(list.getFontMetrics(list.getFont()), value, isSelected);
        cellRendererComponent.setOpaque(true);
        if (isSelected) {
            cellRendererComponent.setBackground(list.getSelectionBackground());
            cellRendererComponent.setForeground(list.getSelectionForeground());
        } else {
            cellRendererComponent.setBackground(list.getBackground());
            cellRendererComponent.setForeground(list.getForeground());
        }
        if (index >= 0) {
            list.setToolTipText(cellRendererComponent.getToolTipText());
        }
        return cellRendererComponent;
    }

    public JComponent getCellRendererComponent(FontMetrics fontMetrics, Object value, boolean isSelected) {
        JComponent component;
        if (value == null) {
            component = new JLabel(this.noValueText);
            component.setOpaque(true);
        } else if (value instanceof UIIcon) {
            JLabel label = new JLabel();
            Font font = fontMetrics.getFont();
            label.setFont(font);
            int fontHeight = label.getFontMetrics(font).getHeight();
            UIIcon uiIcon = (UIIcon)value;
            FixedSizeUIIcon icon = FixedSizeUIIcon.withHeight(uiIcon.getUrl(), fontHeight, uiIcon.hasStandardSize());
            label.setIcon(icon);
            label.setHorizontalAlignment(0);
            label.setOpaque(false);
            component = label;
        } else if (value instanceof Tag) {
            JLabel label = new JLabel();
            Tag tag = (Tag)value;
            TagIcon icon = new TagIcon(tag, fontMetrics.getFont());
            label.setIcon(icon);
            label.setHorizontalAlignment(10);
            label.setOpaque(false);
            component = label;
        } else if (value instanceof ASelectableCondition) {
            ASelectableCondition cond = (ASelectableCondition)value;
            String userName = cond.getUserName();
            component = this.renderNamedConditions || userName == null ? cond.getListCellRendererComponent(fontMetrics) : new JLabel(userName);
            component.setOpaque(true);
            component.setToolTipText(cond.toString());
        } else {
            component = new JLabel(value.toString());
            component.setOpaque(true);
        }
        component.setAlignmentX(0.0f);
        return component;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent cellRendererComponent = this.getCellRendererComponent(table.getFontMetrics(table.getFont()), value, isSelected);
        if (isSelected) {
            ((Component)cellRendererComponent).setBackground(table.getSelectionBackground());
            ((Component)cellRendererComponent).setForeground(table.getSelectionForeground());
        } else {
            ((Component)cellRendererComponent).setBackground(table.getBackground());
            ((Component)cellRendererComponent).setForeground(table.getForeground());
        }
        return cellRendererComponent;
    }
}

