/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Morphological watershed transform from markers.


The watershed transform is a tool for image segmentation that is fast
and flexible and potentially fairly parameter free. It was originally
derived from a geophysical model of rain falling on a terrain and a
variety of more formal definitions have been devised to allow
development of practical algorithms. If an image is considered as a
terrain and divided into catchment basins then the hope is that each
catchment basin would contain an object of interest.

The output is a label image. A label image, sometimes referred to as a
categorical image, has unique values for each region. For example, if
a watershed produces 2 regions, all pixels belonging to one region
would have value A, and all belonging to the other might have value B.
Unassigned pixels, such as watershed lines, might have the background
value (0 by convention).

The simplest way of using the watershed is to preprocess the image we
want to segment so that the boundaries of our objects are bright (e.g
apply an edge detector) and compute the watershed transform of the
edge image. Watershed lines will correspond to the boundaries and our
problem will be solved. This is rarely useful in practice because
there are always more regional minima than there are objects, either
due to noise or natural variations in the object surfaces. Therefore,
while many watershed lines do lie on significant boundaries, there are
many that don't. Various methods can be used to reduce the number of
minima in the image, like thresholding the smallest values, filtering
the minima and/or smoothing the image.

This filter use another approach to avoid the problem of over
segmentation: it let the user provide a marker image which mark the
minima in the input image and give them a label. The minima are
imposed in the input image by the markers. The labels of the output
image are the label of the marker image.

The morphological watershed transform algorithm is described in
Chapter 9.2 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.

This code was contributed in the Insight Journal paper: "The
watershed transform in ITK - discussion and new developments" by
Beare R., Lehmann G. https://doi.org/10.54294/lf8u75


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 WatershedImageFilter , MorphologicalWatershedImageFilter

 itk::simple::MorphologicalWatershedFromMarkers for the procedural interface

 itk::MorphologicalWatershedFromMarkersImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMorphologicalWatershedFromMarkersImageFilter.h
*/
public class MorphologicalWatershedFromMarkersImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MorphologicalWatershedFromMarkersImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MorphologicalWatershedFromMarkersImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MorphologicalWatershedFromMarkersImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MorphologicalWatershedFromMarkersImageFilter::~MorphologicalWatershedFromMarkersImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MorphologicalWatershedFromMarkersImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MorphologicalWatershedFromMarkersImageFilter::MorphologicalWatershedFromMarkersImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MorphologicalWatershedFromMarkersImageFilter() {
    this(SimpleITKJNI.new_MorphologicalWatershedFromMarkersImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedFromMarkersImageFilter::SetMarkWatershedLine(bool MarkWatershedLine)

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public  void setMarkWatershedLine(boolean MarkWatershedLine) {
    SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_setMarkWatershedLine(swigCPtr, this, MarkWatershedLine);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedFromMarkersImageFilter::MarkWatershedLineOn()

Set the value of MarkWatershedLine to true or false respectfully.

*/
public  void markWatershedLineOn() {
    SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_markWatershedLineOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedFromMarkersImageFilter::MarkWatershedLineOff()
*/
public  void markWatershedLineOff() {
    SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_markWatershedLineOff(swigCPtr, this);
  }

  /**
bool itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetMarkWatershedLine() const

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public  boolean getMarkWatershedLine() {
    return SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_getMarkWatershedLine(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedFromMarkersImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedFromMarkersImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MorphologicalWatershedFromMarkersImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MorphologicalWatershedFromMarkersImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MorphologicalWatershedFromMarkersImageFilter::Execute(const Image &amp;image, const Image &amp;markerImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image markerImage) {
    return new Image(SimpleITKJNI.MorphologicalWatershedFromMarkersImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(markerImage), markerImage), true);
  }

}
