/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderFactory;

public class RealmSynchronizer
implements Synchronizer<RealmModel.RealmRemovedEvent> {
    @Override
    public void synchronize(RealmModel.RealmRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
        event.getRealm().getClientsStream().forEach(resourceServerStore::delete);
    }
}

