/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BigDecimalJavaType
extends AbstractClassJavaType<BigDecimal> {
    public static final BigDecimalJavaType INSTANCE = new BigDecimalJavaType();

    public BigDecimalJavaType() {
        super(BigDecimal.class);
    }

    @Override
    public String toString(BigDecimal value) {
        return value.toString();
    }

    @Override
    public BigDecimal fromString(CharSequence string) {
        return new BigDecimal(string.toString());
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public boolean areEqual(BigDecimal one, BigDecimal another) {
        return one == another || one != null && another != null && one.compareTo(another) == 0;
    }

    @Override
    public int extractHashCode(BigDecimal value) {
        return value.intValue();
    }

    @Override
    public <X> X unwrap(BigDecimal value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)value.toBigIntegerExact();
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)Byte.valueOf(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)Float.valueOf(value.floatValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> BigDecimal wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal;
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return new BigDecimal(bigInteger);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return new BigDecimal(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "java.math.BigInteger" -> true;
            default -> false;
        };
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlPrecision(dialect, jdbcType) + 2;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultDecimalPrecision();
    }

    @Override
    public <X> BigDecimal coerce(X value, JavaType.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return CoercionHelper.coerceWrappingError(() -> BigDecimal.valueOf(Double.parseDouble(string)));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce value [%s (%s)] to BigDecimal", value, value.getClass().getName()));
    }
}

