/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.logging.QuarkusDelayedHandler;
import io.quarkus.bootstrap.naming.DisabledInitialContextManager;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.builder.Version;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AllowJNDIBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderConstantDefinitionBuildItem;
import io.quarkus.deployment.builditem.BytecodeRecorderObjectLoaderBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedRuntimeSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.JavaLibraryPathAdditionalPathBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.QuarkusApplicationClassBuildItem;
import io.quarkus.deployment.builditem.RecordableConstructorBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.naming.NamingConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.steps.KotlinUtil;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.MethodTransformer;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ExecutionModeManager;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.NativeImageRuntimePropertiesRecorder;
import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import io.quarkus.runtime.annotations.QuarkusMain;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.util.StepTiming;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class MainClassBuildStep {
    static final String MAIN_CLASS = "io.quarkus.runner.GeneratedMain";
    static final String STARTUP_CONTEXT = "STARTUP_CONTEXT";
    static final String LOG = "LOG";
    static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static final String QUARKUS_ANALYTICS_QUARKUS_VERSION = "__QUARKUS_ANALYTICS_QUARKUS_VERSION";
    public static final String GENERATE_APP_CDS_SYSTEM_PROPERTY = "quarkus.appcds.generate";
    private static final FieldDescriptor STARTUP_CONTEXT_FIELD = FieldDescriptor.of((String)"io.quarkus.runner.ApplicationImpl", (String)"STARTUP_CONTEXT", StartupContext.class);
    public static final MethodDescriptor PRINT_STEP_TIME_METHOD = MethodDescriptor.ofMethod((Object)StepTiming.class.getName(), (String)"printStepTime", Void.TYPE, (Object[])new Object[]{StartupContext.class});
    public static final MethodDescriptor CONFIGURE_STEP_TIME_ENABLED = MethodDescriptor.ofMethod((Object)StepTiming.class.getName(), (String)"configureEnabled", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor RUNTIME_EXECUTION_STATIC_INIT = MethodDescriptor.ofMethod((Object)ExecutionModeManager.class.getName(), (String)"staticInit", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor RUNTIME_EXECUTION_RUNTIME_INIT = MethodDescriptor.ofMethod((Object)ExecutionModeManager.class.getName(), (String)"runtimeInit", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor RUNTIME_EXECUTION_RUNNING = MethodDescriptor.ofMethod((Object)ExecutionModeManager.class.getName(), (String)"running", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor RUNTIME_EXECUTION_UNSET = MethodDescriptor.ofMethod((Object)ExecutionModeManager.class.getName(), (String)"unset", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor CONFIGURE_STEP_TIME_START = MethodDescriptor.ofMethod((Object)StepTiming.class.getName(), (String)"configureStart", Void.TYPE, (Object[])new Object[0]);
    private static final DotName QUARKUS_APPLICATION = DotName.createSimple((String)QuarkusApplication.class.getName());
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    private static final Type STRING_ARRAY = Type.create((DotName)DotName.createSimple((String)String[].class.getName()), (Type.Kind)Type.Kind.ARRAY);

    @BuildStep
    void build(List<StaticBytecodeRecorderBuildItem> staticInitTasks, List<ObjectSubstitutionBuildItem> substitutions, List<MainBytecodeRecorderBuildItem> mainMethod, List<SystemPropertyBuildItem> properties, List<GeneratedRuntimeSystemPropertyBuildItem> generatedRuntimeSystemProperties, List<JavaLibraryPathAdditionalPathBuildItem> javaLibraryPathAdditionalPaths, List<FeatureBuildItem> features, BuildProducer<ApplicationClassNameBuildItem> appClassNameProducer, List<BytecodeRecorderObjectLoaderBuildItem> loaders, List<BytecodeRecorderConstantDefinitionBuildItem> constants, List<RecordableConstructorBuildItem> recordableConstructorBuildItems, BuildProducer<GeneratedClassBuildItem> generatedClass, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReloadBuildItem, ApplicationInfoBuildItem applicationInfo, List<AllowJNDIBuildItem> allowJNDIBuildItems, NamingConfig namingConfig) {
        appClassNameProducer.produce(new ApplicationClassNameBuildItem("io.quarkus.runner.ApplicationImpl"));
        GeneratedClassGizmoAdaptor gizmoOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        ClassCreator file = new ClassCreator((ClassOutput)gizmoOutput, "io.quarkus.runner.ApplicationImpl", null, Application.class.getName(), new String[0]);
        FieldCreator logField = (FieldCreator)file.getFieldCreator(LOG, Logger.class).setModifiers(8);
        FieldCreator scField = file.getFieldCreator(STARTUP_CONTEXT_FIELD);
        scField.setModifiers(9);
        FieldCreator quarkusVersionField = (FieldCreator)file.getFieldCreator(QUARKUS_ANALYTICS_QUARKUS_VERSION, String.class).setModifiers(26);
        MethodCreator ctor = file.getMethodCreator("<init>", Void.TYPE, new Class[0]);
        ctor.invokeSpecialMethod(MethodDescriptor.ofMethod(Application.class, (String)"<init>", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), ctor.getThis(), new ResultHandle[]{ctor.load(launchMode.isAuxiliaryApplication())});
        ctor.returnValue(null);
        MethodCreator mv = file.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
        mv.setModifiers(9);
        if (!namingConfig.enableJndi() && allowJNDIBuildItems.isEmpty()) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(DisabledInitialContextManager.class, (String)"register", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        }
        for (SystemPropertyBuildItem i : properties.stream().sorted(Comparator.comparing(SystemPropertyBuildItem::getKey)).toList()) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(i.getKey()), mv.load(i.getValue())});
        }
        ResultHandle lm = mv.readStaticField(FieldDescriptor.of(LaunchMode.class, (String)launchMode.getLaunchMode().name(), LaunchMode.class));
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(LaunchMode.class, (String)"set", Void.TYPE, (Class[])new Class[]{LaunchMode.class}), new ResultHandle[]{lm});
        mv.invokeStaticMethod(CONFIGURE_STEP_TIME_ENABLED, new ResultHandle[0]);
        mv.invokeStaticMethod(RUNTIME_EXECUTION_STATIC_INIT, new ResultHandle[0]);
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"staticInitStarted", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{mv.load(launchMode.isAuxiliaryApplication())});
        mv.invokeStaticMethod(RunTimeConfigurationGenerator.C_ENSURE_INITIALIZED, new ResultHandle[0]);
        if (liveReloadBuildItem.isLiveReload()) {
            mv.invokeStaticMethod(RunTimeConfigurationGenerator.REINIT, new ResultHandle[0]);
        }
        mv.writeStaticField(logField.getFieldDescriptor(), mv.invokeStaticMethod(MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load("io.quarkus.application")}));
        mv.writeStaticField(quarkusVersionField.getFieldDescriptor(), mv.load("__quarkus_analytics__quarkus.version=" + Version.getVersion()));
        ResultHandle startupContext = mv.newInstance(MethodDescriptor.ofConstructor(StartupContext.class, (Class[])new Class[0]), new ResultHandle[0]);
        mv.writeStaticField(scField.getFieldDescriptor(), startupContext);
        TryBlock tryBlock = mv.tryBlock();
        tryBlock.invokeStaticMethod(CONFIGURE_STEP_TIME_START, new ResultHandle[0]);
        for (StaticBytecodeRecorderBuildItem staticBytecodeRecorderBuildItem : staticInitTasks) {
            this.writeRecordedBytecode(staticBytecodeRecorderBuildItem.getBytecodeRecorder(), null, substitutions, recordableConstructorBuildItems, loaders, constants, gizmoOutput, startupContext, (BytecodeCreator)tryBlock);
        }
        tryBlock.returnValue(null);
        CatchBlockCreator cb = tryBlock.addCatch(Throwable.class);
        cb.invokeStaticMethod(MethodDescriptor.ofMethod(ApplicationStateNotification.class, (String)"notifyStartupFailed", Void.TYPE, (Class[])new Class[]{Throwable.class}), new ResultHandle[]{cb.getCaughtException()});
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv = file.getMethodCreator("doStart", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(20);
        for (SystemPropertyBuildItem systemPropertyBuildItem : properties.stream().sorted(Comparator.comparing(SystemPropertyBuildItem::getKey)).toList()) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(systemPropertyBuildItem.getKey()), mv.load(systemPropertyBuildItem.getValue())});
        }
        for (GeneratedRuntimeSystemPropertyBuildItem generatedRuntimeSystemPropertyBuildItem : generatedRuntimeSystemProperties.stream().sorted(Comparator.comparing(GeneratedRuntimeSystemPropertyBuildItem::getKey)).toList()) {
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(generatedRuntimeSystemPropertyBuildItem.getKey()), mv.invokeVirtualMethod(MethodDescriptor.ofMethod((String)generatedRuntimeSystemPropertyBuildItem.getGeneratorClass(), (String)"get", (String)String.class.getName(), (String[])new String[0]), mv.newInstance(MethodDescriptor.ofConstructor((String)generatedRuntimeSystemPropertyBuildItem.getGeneratorClass(), (String[])new String[0]), new ResultHandle[0]), new ResultHandle[0])});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(NativeImageRuntimePropertiesRecorder.class, (String)"doRuntime", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        mv.invokeStaticMethod(RUNTIME_EXECUTION_RUNTIME_INIT, new ResultHandle[0]);
        if (!javaLibraryPathAdditionalPaths.isEmpty()) {
            ResultHandle resultHandle = mv.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getProperty", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH)})});
            for (JavaLibraryPathAdditionalPathBuildItem javaLibraryPathAdditionalPath : javaLibraryPathAdditionalPaths) {
                ResultHandle javaLibraryPathLength = mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"length", Integer.TYPE, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
                mv.ifNonZero(javaLibraryPathLength).trueBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), resultHandle, new ResultHandle[]{mv.load(File.pathSeparator)});
                mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class}), resultHandle, new ResultHandle[]{mv.load(javaLibraryPathAdditionalPath.getPath())});
            }
            mv.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"setProperty", String.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{mv.load(JAVA_LIBRARY_PATH), mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0])});
        }
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"mainStarted", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"setCommandLineArguments", Void.TYPE, (Class[])new Class[]{String[].class}), startupContext, new ResultHandle[]{mv.getMethodParam(0)});
        mv.invokeStaticMethod(CONFIGURE_STEP_TIME_ENABLED, new ResultHandle[0]);
        tryBlock = mv.tryBlock();
        tryBlock.invokeStaticMethod(CONFIGURE_STEP_TIME_START, new ResultHandle[0]);
        for (MainBytecodeRecorderBuildItem mainBytecodeRecorderBuildItem : mainMethod) {
            this.writeRecordedBytecode(mainBytecodeRecorderBuildItem.getBytecodeRecorder(), mainBytecodeRecorderBuildItem.getGeneratedStartupContextClassName(), substitutions, recordableConstructorBuildItems, loaders, constants, gizmoOutput, startupContext, (BytecodeCreator)tryBlock);
        }
        tryBlock.invokeStaticMethod(RUNTIME_EXECUTION_RUNNING, new ResultHandle[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FeatureBuildItem feature : features) {
            if (arrayList.contains(feature.getName())) {
                throw new IllegalStateException("Multiple extensions registered a feature of the same name: " + feature.getName());
            }
            arrayList.add(feature.getName());
        }
        ResultHandle resultHandle = tryBlock.load(arrayList.stream().sorted().collect(Collectors.joining(", ")));
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Timing.class, (String)"printStartupTime", Void.TYPE, (Class[])new Class[]{String.class, String.class, String.class, String.class, List.class, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{tryBlock.load(applicationInfo.getName()), tryBlock.load(applicationInfo.getVersion()), tryBlock.load(Version.getVersion()), resultHandle, tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigUtils.class, (String)"getProfiles", List.class, (Class[])new Class[0]), new ResultHandle[0]), tryBlock.load(LaunchMode.DEVELOPMENT.equals((Object)launchMode.getLaunchMode())), tryBlock.load(launchMode.isAuxiliaryApplication())});
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(QuarkusConsole.class, (String)"start", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
        CatchBlockCreator preventFurtherStepsBlock = tryBlock.addCatch(PreventFurtherStepsException.class);
        preventFurtherStepsBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb = tryBlock.addCatch(Throwable.class);
        if (launchMode.getLaunchMode() != LaunchMode.DEVELOPMENT) {
            ResultHandle delayedHandler = cb.readStaticField(FieldDescriptor.of(InitialConfigurator.class, (String)"DELAYED_HANDLER", QuarkusDelayedHandler.class));
            ResultHandle isActivated = cb.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusDelayedHandler.class, (String)"isActivated", Boolean.TYPE, (Class[])new Class[0]), delayedHandler, new ResultHandle[0]);
            BytecodeCreator isActivatedFalse = cb.ifNonZero(isActivated).falseBranch();
            ResultHandle handlersArray = isActivatedFalse.newArray(Handler.class, 1);
            isActivatedFalse.writeArrayValue(handlersArray, 0, isActivatedFalse.newInstance(MethodDescriptor.ofConstructor(ConsoleHandler.class, (Class[])new Class[0]), new ResultHandle[0]));
            isActivatedFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusDelayedHandler.class, (String)"setHandlers", Handler[].class, (Class[])new Class[]{Handler[].class}), delayedHandler, new ResultHandle[]{handlersArray});
            isActivatedFalse.breakScope();
        }
        cb.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        cb.throwException(RuntimeException.class, "Failed to start quarkus", cb.getCaughtException());
        mv.returnValue(null);
        mv = file.getMethodCreator("doStop", Void.TYPE, new Class[0]);
        mv.setModifiers(20);
        mv.invokeStaticMethod(RUNTIME_EXECUTION_UNSET, new ResultHandle[0]);
        startupContext = mv.readStaticField(scField.getFieldDescriptor());
        mv.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"close", Void.TYPE, (Class[])new Class[0]), startupContext, new ResultHandle[0]);
        mv.returnValue(null);
        mv = file.getMethodCreator("getName", String.class, new Class[0]);
        mv.returnValue(mv.load(applicationInfo.getName()));
        file.close();
    }

    @BuildStep
    public MainClassBuildItem mainClassBuildStep(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<BytecodeTransformerBuildItem> transformedClass, ApplicationArchivesBuildItem applicationArchivesBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, Optional<QuarkusApplicationClassBuildItem> quarkusApplicationClass, PackageConfig packageConfig) {
        Object classInfo;
        String mainClassName = MAIN_CLASS;
        HashMap<String, String> quarkusMainAnnotations = new HashMap<String, String>();
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection quarkusMains = index.getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName()));
        for (AnnotationInstance i : quarkusMains) {
            AnnotationValue nameValue = i.value("name");
            String name = "";
            if (nameValue != null) {
                name = nameValue.asString();
            }
            classInfo = i.target().asClass();
            if (quarkusMainAnnotations.containsKey(name)) {
                throw new RuntimeException("More than one @QuarkusMain method found with name '" + name + "': " + String.valueOf(classInfo.name()) + " and " + (String)quarkusMainAnnotations.get(name));
            }
            quarkusMainAnnotations.put(name, MainClassBuildStep.sanitizeMainClassName((ClassInfo)classInfo, index));
        }
        MethodInfo mainClassMethod = null;
        if (packageConfig.mainClass().isPresent()) {
            String mainAnnotationClass = (String)quarkusMainAnnotations.get(packageConfig.mainClass().get());
            mainClassName = mainAnnotationClass != null ? mainAnnotationClass : packageConfig.mainClass().get();
        } else if (quarkusMainAnnotations.containsKey("")) {
            mainClassName = (String)quarkusMainAnnotations.get("");
        }
        if (mainClassName.equals(MAIN_CLASS)) {
            if (quarkusApplicationClass.isPresent()) {
                this.generateMainForQuarkusApplication(quarkusApplicationClass.get().getClassName(), generatedClass);
            } else {
                ClassCreator file = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
                MethodCreator mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
                mv.setModifiers(9);
                mv.invokeStaticMethod(MethodDescriptor.ofMethod(Quarkus.class, (String)"run", Void.TYPE, (Class[])new Class[]{String[].class}), new ResultHandle[]{mv.getMethodParam(0)});
                mv.returnValue(null);
                file.close();
            }
        } else {
            Collection impls = index.getAllKnownImplementors(QUARKUS_APPLICATION);
            ClassInfo classByName = index.getClassByName(DotName.createSimple((String)mainClassName));
            if (classByName != null) {
                mainClassMethod = classByName.method("main", new Type[]{STRING_ARRAY});
            }
            if (mainClassMethod == null) {
                boolean found = false;
                for (ClassInfo i : impls) {
                    if (!i.name().toString().equals(mainClassName)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.generateMainForQuarkusApplication(mainClassName, generatedClass);
                    mainClassName = MAIN_CLASS;
                } else {
                    classInfo = index.getClassByName(DotName.createSimple((String)mainClassName));
                    if (classInfo == null) {
                        throw new IllegalArgumentException("The supplied 'main-class' value of '" + mainClassName + "' does not correspond to either a fully qualified class name or a matching 'name' field of one of the '@QuarkusMain' annotations");
                    }
                }
            }
        }
        if (!(mainClassName.equals(MAIN_CLASS) || mainClassMethod != null && Modifier.isPublic(mainClassMethod.flags()))) {
            transformedClass.produce(new BytecodeTransformerBuildItem(mainClassName, new MainMethodTransformer(index)));
        }
        return new MainClassBuildItem(mainClassName);
    }

    private static String sanitizeMainClassName(ClassInfo mainClass, IndexView index) {
        boolean hasQuarkusApplicationInterface;
        MethodInfo mainMethod;
        DotName mainClassDotName = mainClass.name();
        Object className = mainClassDotName.toString();
        if (KotlinUtil.isKotlinClass(mainClass) && (mainMethod = mainClass.method("main", new Type[]{ArrayType.create((Type)Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS), (int)1)})) == null && !(hasQuarkusApplicationInterface = index.getAllKnownImplementors(QUARKUS_APPLICATION).stream().map(ClassInfo::name).anyMatch(d -> d.equals((Object)mainClassDotName)))) {
            className = (String)className + "Kt";
        }
        return className;
    }

    private void generateMainForQuarkusApplication(String quarkusApplicationClassName, BuildProducer<GeneratedClassBuildItem> generatedClass) {
        ClassCreator file = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true), MAIN_CLASS, null, Object.class.getName(), new String[0]);
        MethodCreator mv = file.getMethodCreator("main", Void.TYPE, new Class[]{String[].class});
        mv.setModifiers(9);
        mv.invokeStaticMethod(MethodDescriptor.ofMethod(Quarkus.class, (String)"run", Void.TYPE, (Class[])new Class[]{Class.class, String[].class}), new ResultHandle[]{mv.loadClassFromTCCL(quarkusApplicationClassName), mv.getMethodParam(0)});
        mv.returnValue(null);
        file.close();
    }

    private void writeRecordedBytecode(BytecodeRecorderImpl recorder, String fallbackGeneratedStartupTaskClassName, List<ObjectSubstitutionBuildItem> substitutions, List<RecordableConstructorBuildItem> recordableConstructorBuildItems, List<BytecodeRecorderObjectLoaderBuildItem> loaders, List<BytecodeRecorderConstantDefinitionBuildItem> constants, GeneratedClassGizmoAdaptor gizmoOutput, ResultHandle startupContext, BytecodeCreator bytecodeCreator) {
        if ((recorder == null || recorder.isEmpty()) && fallbackGeneratedStartupTaskClassName == null) {
            return;
        }
        if (recorder != null && !recorder.isEmpty()) {
            for (ObjectSubstitutionBuildItem objectSubstitutionBuildItem : substitutions) {
                ObjectSubstitutionBuildItem.Holder<?, ?> holder1 = objectSubstitutionBuildItem.holder;
                recorder.registerSubstitution(holder1.from, holder1.to, holder1.substitution);
            }
            for (BytecodeRecorderObjectLoaderBuildItem bytecodeRecorderObjectLoaderBuildItem : loaders) {
                recorder.registerObjectLoader(bytecodeRecorderObjectLoaderBuildItem.getObjectLoader());
            }
            for (RecordableConstructorBuildItem recordableConstructorBuildItem : recordableConstructorBuildItems) {
                recorder.markClassAsConstructorRecordable(recordableConstructorBuildItem.getClazz());
            }
            for (BytecodeRecorderConstantDefinitionBuildItem bytecodeRecorderConstantDefinitionBuildItem : constants) {
                bytecodeRecorderConstantDefinitionBuildItem.register(recorder);
            }
            recorder.writeBytecode(gizmoOutput);
        }
        ResultHandle dup = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor((String)(recorder != null ? recorder.getClassName() : fallbackGeneratedStartupTaskClassName), (String[])new String[0]), new ResultHandle[0]);
        bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(StartupTask.class, (String)"deploy", Void.TYPE, (Class[])new Class[]{StartupContext.class}), dup, new ResultHandle[]{startupContext});
        bytecodeCreator.invokeStaticMethod(PRINT_STEP_TIME_METHOD, new ResultHandle[]{startupContext});
    }

    @BuildStep
    ReflectiveClassBuildItem applicationReflection() {
        return ReflectiveClassBuildItem.builder("io.quarkus.runner.ApplicationImpl").reason("The generated application class").build();
    }

    @BuildStep
    ReflectiveFieldBuildItem setupVersionField() {
        return new ReflectiveFieldBuildItem("Ensure it's included in the executable to be able to grep the quarkus version", "io.quarkus.runner.ApplicationImpl", QUARKUS_ANALYTICS_QUARKUS_VERSION);
    }

    private static class MainMethodTransformer
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final IndexView index;

        public MainMethodTransformer(IndexView index) {
            this.index = index;
        }

        @Override
        public ClassVisitor apply(String mainClassName, ClassVisitor outputClassVisitor) {
            ClassInfo mainClassInfo = this.index.getClassByName(mainClassName);
            if (mainClassInfo == null) {
                throw new IllegalStateException(mainClassName + " should have a corresponding ClassInfo at this point");
            }
            ClassTransformer transformer = new ClassTransformer(mainClassName);
            Result result = this.doApply(mainClassName, outputClassVisitor, transformer, mainClassInfo);
            if (!result.isValid) {
                throw new RuntimeException(MainMethodTransformer.errorMessage(mainClassName));
            }
            if (result.classVisitor == null) {
                throw new IllegalStateException("result.classvisitor should not be null at this point");
            }
            return result.classVisitor;
        }

        private Result doApply(String originalMainClassName, ClassVisitor classVisitor, ClassTransformer transformer, ClassInfo currentClassInfo) {
            Result result;
            boolean isTopLevel;
            boolean allowStatic = isTopLevel = currentClassInfo.name().toString().equals(originalMainClassName);
            boolean hasStaticWithArgs = false;
            boolean hasStaticWithoutArgs = false;
            boolean hasInstanceWithArgs = false;
            boolean hasInstanceWithoutArgs = false;
            MethodInfo withArgs = currentClassInfo.method("main", new Type[]{STRING_ARRAY});
            MethodInfo withoutArgs = currentClassInfo.method("main", new Type[0]);
            if (withArgs != null) {
                if (Modifier.isStatic(withArgs.flags())) {
                    if (allowStatic) {
                        hasStaticWithArgs = true;
                    }
                } else {
                    hasInstanceWithArgs = true;
                }
            }
            if (withoutArgs != null) {
                if (Modifier.isStatic(withoutArgs.flags())) {
                    if (allowStatic) {
                        hasStaticWithoutArgs = true;
                    }
                } else {
                    hasInstanceWithoutArgs = true;
                }
            }
            if (hasStaticWithArgs) {
                if (Modifier.isPublic(withArgs.flags())) {
                    result = Result.valid(classVisitor);
                } else if (Modifier.isPrivate(withArgs.flags())) {
                    transformer.modifyMethod(MethodDescriptor.of((MethodInfo)withArgs)).rename("$originalMain$");
                    result = Result.invalid(transformer.applyTo(classVisitor));
                } else {
                    ((MethodTransformer)transformer.modifyMethod(MethodDescriptor.of((MethodInfo)withArgs)).removeModifiers(4)).addModifiers(1);
                    result = Result.valid(transformer.applyTo(classVisitor));
                }
            } else if (hasStaticWithoutArgs) {
                if (Modifier.isPrivate(withoutArgs.flags())) {
                    result = Result.invalid();
                } else {
                    MethodCreator standardMain = MainMethodTransformer.createStandardMain(transformer);
                    standardMain.invokeStaticMethod(MethodDescriptor.of((MethodInfo)withoutArgs), new ResultHandle[0]);
                    standardMain.returnValue(null);
                    result = Result.valid(transformer.applyTo(classVisitor));
                }
            } else if (hasInstanceWithArgs) {
                if (Modifier.isPrivate(withArgs.flags())) {
                    transformer.modifyMethod(MethodDescriptor.of((MethodInfo)withArgs)).rename("$originalMain$");
                    result = Result.invalid(transformer.applyTo(classVisitor));
                } else {
                    MethodCreator standardMain = MainMethodTransformer.createStandardMain(transformer);
                    ResultHandle instanceHandle = standardMain.newInstance(MethodDescriptor.ofConstructor((String)originalMainClassName, (String[])new String[0]), new ResultHandle[0]);
                    ResultHandle argsParamHandle = standardMain.getMethodParam(0);
                    if (isTopLevel) {
                        standardMain.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)originalMainClassName, (String)"$$main$$", Void.TYPE, (Object[])new Object[]{String[].class}), instanceHandle, new ResultHandle[]{argsParamHandle});
                        transformer.modifyMethod(MethodDescriptor.of((MethodInfo)withArgs)).rename("$$main$$");
                    } else {
                        standardMain.invokeSpecialMethod(withArgs, instanceHandle, new ResultHandle[]{argsParamHandle});
                    }
                    standardMain.returnValue(null);
                    result = Result.valid(transformer.applyTo(classVisitor));
                }
            } else if (hasInstanceWithoutArgs) {
                if (Modifier.isPrivate(withoutArgs.flags())) {
                    result = Result.invalid();
                } else {
                    MethodCreator standardMain = MainMethodTransformer.createStandardMain(transformer);
                    ResultHandle instanceHandle = standardMain.newInstance(MethodDescriptor.ofConstructor((String)originalMainClassName, (String[])new String[0]), new ResultHandle[0]);
                    standardMain.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)withoutArgs), instanceHandle, new ResultHandle[0]);
                    standardMain.returnValue(null);
                    result = Result.valid(transformer.applyTo(classVisitor));
                }
            } else {
                result = this.resultFromSuper(originalMainClassName, classVisitor, transformer, currentClassInfo);
            }
            if (!result.isValid) {
                result = this.resultFromSuper(originalMainClassName, classVisitor, transformer, currentClassInfo);
            }
            return result;
        }

        private Result resultFromSuper(String originalMainClassName, ClassVisitor outputClassVisitor, ClassTransformer transformer, ClassInfo currentClassInfo) {
            DotName superName = currentClassInfo.superName();
            if (superName.equals((Object)OBJECT)) {
                return Result.invalid();
            }
            ClassInfo superClassInfo = this.index.getClassByName(superName);
            if (superClassInfo == null) {
                throw new IllegalStateException("Unable to find main method on class '" + originalMainClassName + "' while it was also not possible to traverse the class hierarchy");
            }
            return this.doApply(originalMainClassName, outputClassVisitor, transformer, superClassInfo);
        }

        private static String errorMessage(String originalMainClassName) {
            return "Unable to find a valid main method on class '" + originalMainClassName + "'. See https://openjdk.org/jeps/445 for details of what constitutes a valid main method.";
        }

        private static MethodCreator createStandardMain(ClassTransformer transformer) {
            return (MethodCreator)transformer.addMethod("main", Void.TYPE, new Object[]{String[].class}).setModifiers(9);
        }

        private static class Result {
            private final boolean isValid;
            private final ClassVisitor classVisitor;

            private Result(boolean isValid, ClassVisitor classVisitor) {
                this.isValid = isValid;
                this.classVisitor = classVisitor;
            }

            private static Result valid(ClassVisitor classVisitor) {
                return new Result(true, classVisitor);
            }

            private static Result invalid(ClassVisitor classVisitor) {
                return new Result(false, classVisitor);
            }

            private static Result invalid() {
                return new Result(false, null);
            }
        }
    }
}

