/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.TypeArgument;
import io.quarkus.gizmo2.TypeParameter;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.AnnotatableCreatorImpl;
import io.quarkus.gizmo2.impl.TypeAnnotatableCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import java.lang.annotation.Target;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class Reflection2Gizmo {
    public static ClassDesc classDescOf(Class<?> clazz) {
        return Util.classDesc(clazz);
    }

    public static ClassDesc erasureOf(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return Util.classDesc(c);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return Util.classDesc((Class)pt.getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return tv.getBounds().length == 0 ? ConstantDescs.CD_Object : Reflection2Gizmo.erasureOf(tv.getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return wt.getUpperBounds().length == 0 ? ConstantDescs.CD_Object : Reflection2Gizmo.erasureOf(wt.getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Reflection2Gizmo.erasureOf(gat.getGenericComponentType()).arrayType();
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }

    public static GenericType genericTypeOf(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return GenericType.of(c);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Reflection2Gizmo.genericTypeOf(gat);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return Reflection2Gizmo.genericTypeOf(pt);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return Reflection2Gizmo.genericTypeOf(tv);
        }
        if (type instanceof WildcardType) {
            throw Reflection2Gizmo.noWildcards();
        }
        throw new IllegalArgumentException("Invalid type " + String.valueOf(type.getClass()));
    }

    public static GenericType.OfArray genericTypeOf(GenericArrayType type) {
        return Reflection2Gizmo.genericTypeOf(type.getGenericComponentType()).arrayType();
    }

    public static GenericType.OfTypeVariable genericTypeOf(TypeVariable<?> type) {
        return GenericType.ofTypeVariable(type.getName(), Reflection2Gizmo.erasureOf(type));
    }

    public static GenericType.OfClass genericTypeOf(ParameterizedType type) {
        return ((GenericType.OfClass)Reflection2Gizmo.genericTypeOf(type.getRawType())).withArguments(Stream.of(type.getActualTypeArguments()).map(Reflection2Gizmo::typeArgumentOf).toList());
    }

    public static GenericType genericTypeOf(AnnotatedType type) {
        if (type instanceof AnnotatedArrayType) {
            AnnotatedArrayType aat = (AnnotatedArrayType)type;
            return Reflection2Gizmo.genericTypeOf(aat);
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType apt = (AnnotatedParameterizedType)type;
            return Reflection2Gizmo.genericTypeOf(apt);
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable atv = (AnnotatedTypeVariable)type;
            return Reflection2Gizmo.genericTypeOf(atv);
        }
        if (type instanceof AnnotatedWildcardType) {
            throw Reflection2Gizmo.noWildcards();
        }
        return Reflection2Gizmo.genericTypeOf(type.getType()).withAnnotations(Reflection2Gizmo.copyAnnotations(type));
    }

    public static GenericType.OfArray genericTypeOf(AnnotatedArrayType type) {
        return Reflection2Gizmo.genericTypeOf(type.getAnnotatedGenericComponentType()).arrayType().withAnnotations((Consumer)Reflection2Gizmo.copyAnnotations(type));
    }

    public static GenericType genericTypeOf(AnnotatedParameterizedType type) {
        List<TypeArgument> typeArgs = Stream.of(type.getAnnotatedActualTypeArguments()).map(Reflection2Gizmo::typeArgumentOf).toList();
        ParameterizedType pt = (ParameterizedType)type.getType();
        return GenericType.of((Class)pt.getRawType(), typeArgs).withAnnotations(Reflection2Gizmo.copyAnnotations(type));
    }

    public static GenericType.OfTypeVariable genericTypeOf(AnnotatedTypeVariable type) {
        TypeVariable typeVar = (TypeVariable)type.getType();
        return GenericType.ofTypeVariable(typeVar.getName(), Reflection2Gizmo.erasureOf(typeVar)).withAnnotations((Consumer)Reflection2Gizmo.copyAnnotations(type));
    }

    public static TypeParameter typeParameterOf(TypeVariable<?> typeVar) {
        List<GenericType.OfThrows> otherBounds;
        Optional<GenericType.OfThrows> firstBound;
        List<GenericType.OfThrows> allBounds = Stream.of(typeVar.getAnnotatedBounds()).map(Reflection2Gizmo::genericTypeOf).map(GenericType.OfThrows.class::cast).toList();
        if (allBounds.isEmpty() || allBounds.size() == 1 && allBounds.get(0).equals(GenericType.ofClass(Object.class))) {
            firstBound = Optional.empty();
            otherBounds = List.of();
        } else {
            Class c;
            Type type = typeVar.getBounds()[0];
            if (type instanceof Class && !(c = (Class)type).isInterface()) {
                firstBound = Optional.of(allBounds.get(0));
                otherBounds = allBounds.subList(1, allBounds.size());
            } else if (allBounds.size() == 1 && allBounds.get(0) instanceof GenericType.OfTypeVariable) {
                firstBound = Optional.of(allBounds.get(0));
                otherBounds = List.of();
            } else {
                firstBound = Optional.empty();
                otherBounds = allBounds;
            }
        }
        TypeAnnotatableCreatorImpl tac = new TypeAnnotatableCreatorImpl();
        Reflection2Gizmo.copyAnnotations(typeVar).accept(tac);
        Object decl = typeVar.getGenericDeclaration();
        if (decl instanceof Class) {
            Class c = (Class)decl;
            return new TypeParameter.OfType(tac.visible(), List.of(), typeVar.getName(), firstBound, otherBounds, Util.classDesc(c));
        }
        if (decl instanceof Method) {
            Method m = (Method)decl;
            return new TypeParameter.OfMethod(tac.visible(), List.of(), typeVar.getName(), firstBound, otherBounds, MethodDesc.of(m));
        }
        if (decl instanceof Constructor) {
            Constructor c = (Constructor)decl;
            return new TypeParameter.OfConstructor(tac.visible(), List.of(), typeVar.getName(), firstBound, otherBounds, ConstructorDesc.of(c));
        }
        throw new IllegalStateException("Unexpected declaration " + String.valueOf(decl));
    }

    public static TypeArgument typeArgumentOf(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return Reflection2Gizmo.typeArgumentOf(wt);
        }
        return TypeArgument.ofExact((GenericType.OfReference)Reflection2Gizmo.genericTypeOf(type));
    }

    public static TypeArgument.OfWildcard typeArgumentOf(WildcardType type) {
        Type[] ub = type.getUpperBounds();
        Type[] lb = type.getLowerBounds();
        if (lb.length > 0) {
            return TypeArgument.ofSuper((GenericType.OfReference)Reflection2Gizmo.genericTypeOf(lb[0]));
        }
        if (ub.length == 0 || ub.length == 1 && ub[0].equals(Object.class)) {
            return TypeArgument.ofUnbounded();
        }
        return TypeArgument.ofExtends((GenericType.OfReference)Reflection2Gizmo.genericTypeOf(ub[0]));
    }

    public static TypeArgument typeArgumentOf(AnnotatedType type) {
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType wt = (AnnotatedWildcardType)type;
            return Reflection2Gizmo.typeArgumentOf(wt);
        }
        return TypeArgument.ofExact((GenericType.OfReference)Reflection2Gizmo.genericTypeOf(type));
    }

    public static TypeArgument.OfWildcard typeArgumentOf(AnnotatedWildcardType type) {
        AnnotatedType[] aub = type.getAnnotatedUpperBounds();
        AnnotatedType[] alb = type.getAnnotatedLowerBounds();
        if (alb.length > 0) {
            return TypeArgument.ofSuper((GenericType.OfReference)Reflection2Gizmo.genericTypeOf(alb[0])).withAnnotations((Consumer)Reflection2Gizmo.copyAnnotations(type));
        }
        if (aub.length == 0 || aub.length == 1 && aub[0].getType().equals(Object.class) && aub[0].getAnnotations().length == 0) {
            return TypeArgument.ofUnbounded().withAnnotations((Consumer)Reflection2Gizmo.copyAnnotations(type));
        }
        return TypeArgument.ofExtends((GenericType.OfReference)Reflection2Gizmo.genericTypeOf(aub[0])).withAnnotations((Consumer)Reflection2Gizmo.copyAnnotations(type));
    }

    public static Consumer<AnnotatableCreator> copyAnnotations(AnnotatedElement element) {
        return ac -> Stream.of(element.getAnnotations()).filter(a -> Set.of(Objects.requireNonNull(a.annotationType().getAnnotation(Target.class)).value()).contains((Object)((AnnotatableCreatorImpl)ac).annotationTargetType())).forEach(ac::addAnnotation);
    }

    private static IllegalArgumentException noWildcards() {
        return new IllegalArgumentException("Wildcard types can only be used as type arguments (use `typeArgumentOf()`)");
    }
}

