/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.httpcore.OutputChannel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import io.undertow.util.QValueParser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PreCompressedResourceSupplier
implements ResourceSupplier {
    private final ResourceManager resourceManager;
    private final Map<String, String> encodingMap = new CopyOnWriteMap<String, String>();

    public PreCompressedResourceSupplier(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public Resource getResource(HttpServerExchange exchange, String path) throws IOException {
        Resource originalResource = this.resourceManager.getResource(path);
        if (exchange.containsRequestHeader("Range")) {
            return originalResource;
        }
        Resource resource = this.getEncodedResource(exchange, path, originalResource);
        if (resource == null) {
            return originalResource;
        }
        return resource;
    }

    private Resource getEncodedResource(HttpServerExchange exchange, String path, final Resource originalResource) throws IOException {
        List<String> res = exchange.getRequestHeaders("Accept-Encoding");
        if (res == null || res.isEmpty()) {
            return null;
        }
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (List<QValueParser.QValueResult> result : found) {
            for (final QValueParser.QValueResult value : result) {
                String newPath;
                Resource resource;
                String extension = this.encodingMap.get(value.getValue());
                if (extension == null || (resource = this.resourceManager.getResource(newPath = path + extension)) == null || resource.isDirectory()) continue;
                return new Resource(){

                    @Override
                    public String getPath() {
                        return resource.getPath();
                    }

                    @Override
                    public Date getLastModified() {
                        return resource.getLastModified();
                    }

                    @Override
                    public String getLastModifiedString() {
                        return resource.getLastModifiedString();
                    }

                    @Override
                    public ETag getETag() {
                        return resource.getETag();
                    }

                    @Override
                    public String getName() {
                        return resource.getName();
                    }

                    @Override
                    public boolean isDirectory() {
                        return false;
                    }

                    @Override
                    public List<Resource> list() {
                        return resource.list();
                    }

                    @Override
                    public String getContentType(MimeMappings mimeMappings) {
                        return originalResource.getContentType(mimeMappings);
                    }

                    @Override
                    public void serveBlocking(OutputStream outputStream, HttpServerExchange exchange) throws IOException {
                        exchange.setResponseHeader("Content-Encoding", value.getValue());
                        resource.serveBlocking(outputStream, exchange);
                    }

                    @Override
                    public void serveAsync(OutputChannel stream, HttpServerExchange exchange) {
                        exchange.setResponseHeader("Content-Encoding", value.getValue());
                        resource.serveAsync(stream, exchange);
                    }

                    @Override
                    public Long getContentLength() {
                        return resource.getContentLength();
                    }

                    @Override
                    public String getCacheKey() {
                        return resource.getCacheKey();
                    }

                    @Override
                    public File getFile() {
                        return resource.getFile();
                    }

                    @Override
                    public Path getFilePath() {
                        return resource.getFilePath();
                    }

                    @Override
                    public File getResourceManagerRoot() {
                        return resource.getResourceManagerRoot();
                    }

                    @Override
                    public Path getResourceManagerRootPath() {
                        return resource.getResourceManagerRootPath();
                    }

                    @Override
                    public URL getUrl() {
                        return resource.getUrl();
                    }
                };
            }
        }
        return null;
    }

    public PreCompressedResourceSupplier addEncoding(String encoding, String extension) {
        this.encodingMap.put(encoding, extension);
        return this;
    }

    public PreCompressedResourceSupplier removeEncoding(String encoding) {
        this.encodingMap.remove(encoding);
        return this;
    }
}

