/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import java.util.Collections;
import java.util.List;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractJWTClientValidator;
import org.keycloak.services.Urls;

public class FederatedJWTClientValidator
extends AbstractJWTClientValidator {
    private final String expectedTokenIssuer;
    private final int allowedClockSkew;
    private final boolean reusePermitted;
    private int maximumExpirationTime = 300;

    public FederatedJWTClientValidator(ClientAuthenticationFlowContext context, AbstractJWTClientValidator.SignatureValidator signatureValidator, String expectedTokenIssuer, int allowedClockSkew, boolean reusePermitted) throws Exception {
        super(context, signatureValidator, null);
        this.expectedTokenIssuer = expectedTokenIssuer;
        this.allowedClockSkew = allowedClockSkew;
        this.reusePermitted = reusePermitted;
    }

    @Override
    protected String getExpectedTokenIssuer() {
        return this.expectedTokenIssuer;
    }

    @Override
    protected List<String> getExpectedAudiences() {
        return Collections.singletonList(Urls.realmIssuer(this.context.getUriInfo().getBaseUri(), this.realm.getName()));
    }

    @Override
    protected boolean isMultipleAudienceAllowed() {
        return false;
    }

    @Override
    protected int getAllowedClockSkew() {
        return this.allowedClockSkew;
    }

    @Override
    protected int getMaximumExpirationTime() {
        return this.maximumExpirationTime;
    }

    public void setMaximumExpirationTime(int maximumExpirationTime) {
        this.maximumExpirationTime = maximumExpirationTime;
    }

    @Override
    protected boolean isReusePermitted() {
        return this.reusePermitted;
    }

    @Override
    protected String getExpectedSignatureAlgorithm() {
        return null;
    }

    public void setExpectedClientAssertionType(String clientAssertionType) {
        this.expectedClientAssertionType = clientAssertionType;
    }
}

