function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useEffect, useState } from 'react';
import PropTypes from "prop-types";
import classnames from 'classnames';
import { EuiModal } from './modal';
import { EuiModalFooter } from './modal_footer';
import { EuiModalHeader } from './modal_header';
import { EuiModalHeaderTitle } from './modal_header_title';
import { EuiModalBody } from './modal_body';
import { EuiButton, EuiButtonEmpty } from '../button';
import { EuiText } from '../text';
export var CONFIRM_BUTTON = 'confirm';
export var CANCEL_BUTTON = 'cancel';
export var EuiConfirmModal = function EuiConfirmModal(_ref) {
  var children = _ref.children,
    title = _ref.title,
    onCancel = _ref.onCancel,
    onConfirm = _ref.onConfirm,
    cancelButtonText = _ref.cancelButtonText,
    confirmButtonText = _ref.confirmButtonText,
    confirmButtonDisabled = _ref.confirmButtonDisabled,
    className = _ref.className,
    _ref$buttonColor = _ref.buttonColor,
    buttonColor = _ref$buttonColor === void 0 ? 'primary' : _ref$buttonColor,
    defaultFocusedButton = _ref.defaultFocusedButton,
    isLoading = _ref.isLoading,
    rest = _objectWithoutProperties(_ref, ["children", "title", "onCancel", "onConfirm", "cancelButtonText", "confirmButtonText", "confirmButtonDisabled", "className", "buttonColor", "defaultFocusedButton", "isLoading"]);
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    cancelButton = _useState2[0],
    setCancelButton = _useState2[1];
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    confirmButton = _useState4[0],
    setConfirmButton = _useState4[1];
  useEffect(function () {
    // We have to do this instead of using `autoFocus` because React's polyfill for auto-focusing
    // elements conflicts with the focus-trap logic we have on EuiModal.
    // Wait a beat for the focus-trap to complete, and then set focus to the right button. Check that
    // the buttons exist first, because it's possible the modal has been closed already.
    requestAnimationFrame(function () {
      if (defaultFocusedButton === CANCEL_BUTTON && cancelButton) {
        cancelButton.focus();
      } else if (defaultFocusedButton === CONFIRM_BUTTON && confirmButton) {
        confirmButton.focus();
      }
    });
  });
  var confirmRef = function confirmRef(node) {
    return setConfirmButton(node);
  };
  var cancelRef = function cancelRef(node) {
    return setCancelButton(node);
  };
  var classes = classnames('euiModal--confirmation', className);
  var modalTitle;
  if (title) {
    modalTitle = /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, {
      "data-test-subj": "confirmModalTitleText"
    }, title));
  }
  var message;
  if (typeof children === 'string' && children.length > 0) {
    message = /*#__PURE__*/React.createElement("p", null, children);
  } else {
    message = children;
  }
  return /*#__PURE__*/React.createElement(EuiModal, _extends({
    className: classes,
    onClose: onCancel
  }, rest), modalTitle, message && /*#__PURE__*/React.createElement(EuiModalBody, null, /*#__PURE__*/React.createElement(EuiText, {
    "data-test-subj": "confirmModalBodyText"
  }, message)), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    "data-test-subj": "confirmModalCancelButton",
    onClick: onCancel,
    buttonRef: cancelRef
  }, cancelButtonText), /*#__PURE__*/React.createElement(EuiButton, {
    "data-test-subj": "confirmModalConfirmButton",
    onClick: onConfirm,
    isLoading: isLoading,
    fill: true,
    buttonRef: confirmRef,
    color: buttonColor,
    isDisabled: confirmButtonDisabled
  }, confirmButtonText)));
};
EuiConfirmModal.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node,
  title: PropTypes.node,
  cancelButtonText: PropTypes.node,
  confirmButtonText: PropTypes.node,
  onCancel: PropTypes.func.isRequired,
  onConfirm: PropTypes.func,
  confirmButtonDisabled: PropTypes.bool,
  className: PropTypes.string,
  defaultFocusedButton: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]),
  buttonColor: PropTypes.oneOf(["primary", "accent", "secondary", "success", "warning", "danger", "ghost", "text"]),
  // For docs only, will get passed with ...rest
  /**
     * Sets the max-width of the modal.
     * Set to `true` to use the default (`euiBreakpoints 'm'`),
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  maxWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
     * Passes `isLoading` prop to the confirm button
     */
  isLoading: PropTypes.bool
};