/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            int tmp = this.buffer.get();
            if (tmp < 0) {
                tmp += 256;
            }
            return tmp;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.available() < len) {
            len = this.available();
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }
}

