/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;

public class WalkEvent {
    private ExecutionContext executionContext;
    private JsonSchema schema;
    private String keyword;
    private JsonNode rootNode;
    private JsonNode instanceNode;
    private JsonNodePath instanceLocation;
    private JsonValidator validator;

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public JsonNode getInstanceNode() {
        return this.instanceNode;
    }

    public JsonNodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public <T extends JsonValidator> T getValidator() {
        return (T)this.validator;
    }

    public String toString() {
        return "WalkEvent [evaluationPath=" + this.getSchema().getEvaluationPath() + ", schemaLocation=" + this.getSchema().getSchemaLocation() + ", instanceLocation=" + this.instanceLocation + "]";
    }

    public static WalkEventBuilder builder() {
        return new WalkEventBuilder();
    }

    static class WalkEventBuilder {
        private final WalkEvent walkEvent = new WalkEvent();

        WalkEventBuilder() {
        }

        public WalkEventBuilder executionContext(ExecutionContext executionContext) {
            this.walkEvent.executionContext = executionContext;
            return this;
        }

        public WalkEventBuilder schema(JsonSchema schema) {
            this.walkEvent.schema = schema;
            return this;
        }

        public WalkEventBuilder keyword(String keyword) {
            this.walkEvent.keyword = keyword;
            return this;
        }

        public WalkEventBuilder instanceNode(JsonNode node) {
            this.walkEvent.instanceNode = node;
            return this;
        }

        public WalkEventBuilder rootNode(JsonNode rootNode) {
            this.walkEvent.rootNode = rootNode;
            return this;
        }

        public WalkEventBuilder instanceLocation(JsonNodePath instanceLocation) {
            this.walkEvent.instanceLocation = instanceLocation;
            return this;
        }

        public WalkEventBuilder validator(JsonValidator validator) {
            this.walkEvent.validator = validator;
            return this;
        }

        public WalkEvent build() {
            return this.walkEvent;
        }
    }
}

