/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.AuthItem;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;

public class DecryptPathStructureInput {
    private final String tableName;
    private final List<AuthItem> encryptedStructure;
    private final ICryptographicMaterialsManager cmm;
    private final Map<String, String> encryptionContext;

    protected DecryptPathStructureInput(BuilderImpl builder) {
        this.tableName = builder.tableName();
        this.encryptedStructure = builder.encryptedStructure();
        this.cmm = builder.cmm();
        this.encryptionContext = builder.encryptionContext();
    }

    public String tableName() {
        return this.tableName;
    }

    public List<AuthItem> encryptedStructure() {
        return this.encryptedStructure;
    }

    public ICryptographicMaterialsManager cmm() {
        return this.cmm;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String tableName;
        protected List<AuthItem> encryptedStructure;
        protected ICryptographicMaterialsManager cmm;
        protected Map<String, String> encryptionContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptPathStructureInput model) {
            this.tableName = model.tableName();
            this.encryptedStructure = model.encryptedStructure();
            this.cmm = model.cmm();
            this.encryptionContext = model.encryptionContext();
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public Builder encryptedStructure(List<AuthItem> encryptedStructure) {
            this.encryptedStructure = encryptedStructure;
            return this;
        }

        @Override
        public List<AuthItem> encryptedStructure() {
            return this.encryptedStructure;
        }

        @Override
        public Builder cmm(ICryptographicMaterialsManager cmm) {
            this.cmm = CryptographicMaterialsManager.wrap((ICryptographicMaterialsManager)cmm);
            return this;
        }

        @Override
        public ICryptographicMaterialsManager cmm() {
            return this.cmm;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public DecryptPathStructureInput build() {
            if (Objects.isNull(this.tableName())) {
                throw new IllegalArgumentException("Missing value for required field `tableName`");
            }
            if (Objects.isNull(this.encryptedStructure())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedStructure`");
            }
            if (Objects.isNull(this.cmm())) {
                throw new IllegalArgumentException("Missing value for required field `cmm`");
            }
            return new DecryptPathStructureInput(this);
        }
    }

    public static interface Builder {
        public Builder tableName(String var1);

        public String tableName();

        public Builder encryptedStructure(List<AuthItem> var1);

        public List<AuthItem> encryptedStructure();

        public Builder cmm(ICryptographicMaterialsManager var1);

        public ICryptographicMaterialsManager cmm();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public DecryptPathStructureInput build();
    }
}

