/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class UnsubAckPacket {
    private String reasonString;
    private List<UserProperty> userProperties;
    private List<UnsubAckReasonCode> reasonCodes;

    public String getReasonString() {
        return this.reasonString;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public List<UnsubAckReasonCode> getReasonCodes() {
        return this.reasonCodes;
    }

    private UnsubAckPacket() {
    }

    private void nativeAddUnsubackCode(int reasonCode) {
        if (this.reasonCodes == null) {
            this.reasonCodes = new ArrayList<UnsubAckReasonCode>();
        }
        this.reasonCodes.add(UnsubAckReasonCode.getEnumValueFromInteger(reasonCode));
    }

    public static enum UnsubAckReasonCode {
        SUCCESS(0),
        NO_SUBSCRIPTION_EXISTED(17),
        UNSPECIFIED_ERROR(128),
        IMPLEMENTATION_SPECIFIC_ERROR(131),
        NOT_AUTHORIZED(135),
        TOPIC_FILTER_INVALID(143),
        PACKET_IDENTIFIER_IN_USE(145);

        private int reasonCode;
        private static Map<Integer, UnsubAckReasonCode> enumMapping;

        private UnsubAckReasonCode(int code) {
            this.reasonCode = code;
        }

        public int getValue() {
            return this.reasonCode;
        }

        public static UnsubAckReasonCode getEnumValueFromInteger(int value) {
            UnsubAckReasonCode enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal UnsubAckReasonCode");
        }

        private static Map<Integer, UnsubAckReasonCode> buildEnumMapping() {
            return Stream.of(UnsubAckReasonCode.values()).collect(Collectors.toMap(UnsubAckReasonCode::getValue, Function.identity()));
        }

        static {
            enumMapping = UnsubAckReasonCode.buildEnumMapping();
        }
    }
}

