# _Pipe
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-57)</span>

A pipe is a unidirectional data channel that can be used for interprocess
communication. Outgoing pipes are written to by this process, incoming pipes
are read from by this process.


```pony
class ref _Pipe
```

## Constructors

### none
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-68)</span>


Creates a nil pipe for use as a placeholder.


```pony
new ref none()
: _Pipe ref^
```

#### Returns

* [_Pipe](process-_Pipe.md) ref^

---

### outgoing
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-74)</span>


Creates an outgoing pipe.


```pony
new ref outgoing()
: _Pipe ref^ ?
```

#### Returns

* [_Pipe](process-_Pipe.md) ref^ ?

---

### incoming
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-81)</span>


Creates an incoming pipe.


```pony
new ref incoming()
: _Pipe ref^ ?
```

#### Returns

* [_Pipe](process-_Pipe.md) ref^ ?

---

## Public fields

### var near_fd: [U32](builtin-U32.md) val
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-64)</span>



---

### var far_fd: [U32](builtin-U32.md) val
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-65)</span>



---

### var event: [Pointer](builtin-Pointer.md)\[[AsioEvent](builtin-AsioEvent.md) val\] tag
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-66)</span>



---

## Public Functions

### begin
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-131)</span>


Prepare the pipe for read or write, and listening, after the far end has
been handed to the other process.


```pony
fun ref begin(
  owner: AsioEventNotify tag)
: None val
```
#### Parameters

*   owner: [AsioEventNotify](builtin-AsioEventNotify.md) tag

#### Returns

* [None](builtin-None.md) val

---

### close_far
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-142)</span>


Close the far end of the pipe--the end that the other process will be
using. This is used to cleanup this process' handles that it wont use.


```pony
fun ref close_far()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### read
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-152)</span>


```pony
fun ref read(
  read_buf: Array[U8 val] iso,
  offset: USize val)
: (Array[U8 val] iso^ , ISize val , I32 val)
```
#### Parameters

*   read_buf: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso
*   offset: [USize](builtin-USize.md) val

#### Returns

* ([Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso^ , [ISize](builtin-ISize.md) val , [I32](builtin-I32.md) val)

---

### write
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-212)</span>


```pony
fun ref write(
  data: (String box | Array[U8 val] box),
  offset: USize val)
: (ISize val , I32 val)
```
#### Parameters

*   data: ([String](builtin-String.md) box | [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] box)
*   offset: [USize](builtin-USize.md) val

#### Returns

* ([ISize](builtin-ISize.md) val , [I32](builtin-I32.md) val)

---

### is_closed
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-246)</span>


```pony
fun ref is_closed()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### close_near
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-249)</span>


Close the near end of the pipe--the end that this process is using
directly. Also handle unsubscribing the asio event (if there was one). File
descriptors should always be closed _after_ unsubscribing its event,
otherwise there is the possibility of reusing the file descriptor in
another thread and then unsubscribing the reused file descriptor here!
Unsubscribing and closing the file descriptor should be treated as one
operation.


```pony
fun ref close_near()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### close
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-267)</span>


```pony
fun ref close()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### dispose
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-271)</span>


```pony
fun ref dispose()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

## Private Functions

### _create
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-88)</span>


Do the actual system object creation for the pipe.


```pony
fun ref _create()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### _set_fd
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-123)</span>


```pony
fun box _set_fd(
  fd: U32 val,
  flags: I32 val)
: None val ?
```
#### Parameters

*   fd: [U32](builtin-U32.md) val
*   flags: [I32](builtin-I32.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### _set_fl
<span class="source-link">[[Source]](src/process/_pipe.md#L-0-127)</span>


```pony
fun box _set_fl(
  fd: U32 val,
  flags: I32 val)
: None val ?
```
#### Parameters

*   fd: [U32](builtin-U32.md) val
*   flags: [I32](builtin-I32.md) val

#### Returns

* [None](builtin-None.md) val ?

---

