/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.GroupByBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.GroupByBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.GroupByBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PGroupBy;
import com.oracle.graal.python.builtins.objects.itertools.PGrouper;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGroupBy})
public final class GroupByBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GroupByBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GroupByBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PGroupBy self, Object state, @Bind Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached PRaiseNode raiseNode) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            if (!(state instanceof PTuple) || (Integer)lenNode.execute(frame, state) != 3) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "3-tuple");
            }
            Object currValue = getItemNode.execute(frame, state, 0);
            self.setCurrValue(currValue);
            Object tgtKey = getItemNode.execute(frame, state, 1);
            self.setTgtKey(tgtKey);
            Object currKey = getItemNode.execute(frame, state, 2);
            self.setCurrKey(currKey);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduceMarkerNotSet(PGroupBy self, @Bind Node inliningTarget, @Cached InlinedConditionProfile noKeyFuncProfile, @Cached InlinedConditionProfile noValuesProfile, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object keyFunc = self.getKeyFunc();
            if (noKeyFuncProfile.profile(inliningTarget, keyFunc == null)) {
                keyFunc = PNone.NONE;
            }
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple1 = PFactory.createTuple(language, new Object[]{self.getIt(), keyFunc});
            if (noValuesProfile.profile(inliningTarget, !ReduceNode.valuesSet(self))) {
                return PFactory.createTuple(language, new Object[]{type, tuple1});
            }
            PTuple tuple2 = PFactory.createTuple(language, new Object[]{self.getCurrValue(), self.getTgtKey(), self.getCurrKey()});
            return PFactory.createTuple(language, new Object[]{type, tuple1, tuple2});
        }

        private static boolean valuesSet(PGroupBy self) {
            return self.getTgtKey() != null && self.getCurrKey() != null && self.getCurrValue() != null;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PGroupBy self, @Bind Node inliningTarget, @Cached PyIterNextNode nextNode, @Cached CallNode callNode, @Cached PyObjectRichCompareBool eqNode, @Cached InlinedBranchProfile eqProfile, @Cached InlinedConditionProfile hasFuncProfile, @Cached InlinedLoopConditionProfile loopConditionProfile, @Bind PythonLanguage language) {
            self.setCurrGrouper(null);
            while (loopConditionProfile.profile(inliningTarget, NextNode.doGroupByStep(frame, inliningTarget, self, eqProfile, eqNode))) {
                self.groupByStep(frame, inliningTarget, nextNode, callNode, hasFuncProfile);
            }
            self.setTgtKey(self.getCurrKey());
            PGrouper grouper = PFactory.createGrouper(language, self, self.getTgtKey());
            return PFactory.createTuple(language, new Object[]{self.getCurrKey(), grouper});
        }

        private static boolean doGroupByStep(VirtualFrame frame, Node inliningTarget, PGroupBy self, InlinedBranchProfile eqProfile, PyObjectRichCompareBool eqNode) {
            if (self.getCurrKey() == null) {
                return true;
            }
            if (self.getTgtKey() == null) {
                return false;
            }
            eqProfile.enter(inliningTarget);
            return eqNode.executeEq((Frame)frame, inliningTarget, self.getTgtKey(), self.getCurrKey());
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PGroupBy self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="groupby", minNumOfPositionalArgs=2, parameterNames={"cls", "iterable", "key"})
    @ArgumentClinic(name="key", defaultValue="PNone.NONE")
    @GenerateNodeFactory
    public static abstract class GroupByNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GroupByBuiltinsClinicProviders.GroupByNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PGroupBy construct(VirtualFrame frame, Object cls, Object iterable, Object key, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            PGroupBy self = PFactory.createGroupBy(language, cls, getInstanceShape.execute(cls));
            self.setKeyFunc(PGuards.isNone(key) ? null : key);
            self.setIt(getIter.execute((Frame)frame, inliningTarget, iterable));
            return self;
        }
    }
}

