/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotVarargs;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

public abstract class ThreadLocalNodes {

    @GenerateInline(value=false)
    public static abstract class GetThreadLocalDict
    extends PNodeWithContext {
        public abstract PDict execute(VirtualFrame var1, PThreadLocal var2);

        @Specialization
        static PDict get(VirtualFrame frame, PThreadLocal self, @Bind Node inliningTarget, @Cached InlinedBranchProfile create, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotVarargs.CallSlotTpInitNode callInit) {
            PDict dict = self.getThreadLocalDict();
            if (dict == null) {
                create.enter(inliningTarget);
                dict = PFactory.createDict(PythonLanguage.get(inliningTarget));
                self.setThreadLocalDict(dict);
                TpSlots slots = getSlots.execute(inliningTarget, self);
                if (slots.tp_init() != ObjectBuiltins.SLOTS.tp_init()) {
                    callInit.execute(frame, inliningTarget, slots.tp_init(), self, self.getArgs(), self.getKeywords());
                }
            }
            return dict;
        }
    }
}

