/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropArray
implements TruffleObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] array;

    public InteropArray(Object[] array) {
        this.array = array;
    }

    @ExportMessage(name="readArrayElement")
    Object get(long idx) {
        return this.array[(int)idx];
    }

    @ExportMessage(name="getArraySize")
    int size() {
        return this.array.length;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long idx) {
        return idx < (long)this.array.length;
    }
}

